/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.world.level.ChunkPos;

public class ChunkPosGenStream {
    public static Iterator<ChunkPos> getIterator(int genMinX, int genMinZ, int width, int extraRadius) {
        return ChunkPosGenStream.getStream(genMinX, genMinZ, width, extraRadius).iterator();
    }

    public static Stream<ChunkPos> getStream(int genMinX, int genMinZ, int width, int extraRadius) {
        return StreamSupport.stream(new InclusiveChunkPosIterator(genMinX, genMinZ, width, extraRadius), false);
    }

    private static class InclusiveChunkPosIterator
    extends Spliterators.AbstractSpliterator<ChunkPos> {
        private final int minX;
        private final int minZ;
        private final int maxX;
        private final int maxZ;
        int x;
        private int z;

        protected InclusiveChunkPosIterator(int genMinX, int genMinZ, int width, int extraRadius) {
            super(InclusiveChunkPosIterator.getCount(width, extraRadius), 64);
            this.minX = genMinX - extraRadius;
            this.minZ = genMinZ - extraRadius;
            this.maxX = genMinX + (width - 1) + extraRadius;
            this.maxZ = genMinZ + (width - 1) + extraRadius;
            this.x = this.minX - 1;
            this.z = this.minZ;
        }

        private static int getCount(int width, int extraRadius) {
            int widthPlusExtra = width + extraRadius * 2;
            return widthPlusExtra * widthPlusExtra;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ChunkPos> consumer) {
            if (this.x == this.maxX && this.z == this.maxZ) {
                return false;
            }
            if (this.x == this.maxX) {
                this.x = this.minX;
                ++this.z;
            } else {
                ++this.x;
            }
            consumer.accept((ChunkPos)new ChunkPos(this.x, this.z));
            return true;
        }
    }
}

