/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.file.ConfigFileHandler;
import com.seibel.distanthorizons.core.config.types.AbstractConfigBase;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.ConfigUISpacer;
import com.seibel.distanthorizons.core.config.types.ConfigUiLinkedEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.ILangWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigHandler {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftSharedWrapper MC_SHARED = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class);
    private static final List<Class<?>> ACCEPTABLE_INPUTS = new ArrayList<Class<?>>(){
        {
            this.add(Boolean.class);
            this.add(Byte.class);
            this.add(Integer.class);
            this.add(Double.class);
            this.add(Short.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(String.class);
            this.add(List.class);
            this.add(ArrayList.class);
            this.add(Map.class);
            this.add(HashMap.class);
        }
    };
    public static final ConfigHandler INSTANCE = new ConfigHandler();
    public final ConfigFileHandler configFileHandler = new ConfigFileHandler(ConfigHandler.getConfigPath());
    public final List<AbstractConfigBase<?>> configBaseList = new ArrayList();
    public boolean isLoaded = false;
    public boolean runMinMaxValidation = true;

    public static void tryRunFirstTimeSetup() {
        if (ConfigHandler.INSTANCE.isLoaded) {
            LOGGER.debug("ConfigHandler setup already run, ignoring.", new Object[0]);
            return;
        }
        INSTANCE.runFirstTimeSetup();
    }

    private void runFirstTimeSetup() {
        LOGGER.info("Initialising config for [DistantHorizons]", new Object[0]);
        this.initNestedClass(Config.class, "");
        this.configFileHandler.loadFromFile();
        this.runMinMaxValidation = Config.Client.Advanced.Debugging.allowUnsafeValues.get() == false;
        this.isLoaded = true;
        LOGGER.info("[DistantHorizons] Config initialised", new Object[0]);
    }

    private static Path getConfigPath() {
        return MC_SHARED.getInstallationDirectory().toPath().resolve("config").resolve("DistantHorizons.toml");
    }

    private void initNestedClass(Class<?> configClass, String category) {
        Field[] fields;
        for (Field field : fields = configClass.getFields()) {
            if (!AbstractConfigBase.class.isAssignableFrom(field.getType())) continue;
            try {
                this.configBaseList.add((AbstractConfigBase)field.get(field.getType()));
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Unable to add config [" + field.getType().getName() + "], error: [" + e.getMessage() + "].", e);
                continue;
            }
            AbstractConfigBase<?> configBase = this.configBaseList.get(this.configBaseList.size() - 1);
            configBase.category = category;
            configBase.name = field.getName();
            if (ConfigEntry.class.isAssignableFrom(field.getType()) && !ConfigHandler.isAcceptableType(configBase.getType())) {
                LOGGER.error("Invalid variable type at [" + (category.isEmpty() ? "" : category + ".") + field.getName() + "].", new Object[0]);
                LOGGER.error("Type [" + configBase.getType() + "] is not one of these types [" + ACCEPTABLE_INPUTS.toString() + "]", new Object[0]);
                this.configBaseList.remove(this.configBaseList.size() - 1);
            }
            if (!ConfigCategory.class.isAssignableFrom(field.getType())) continue;
            ConfigCategory configCategory = (ConfigCategory)configBase;
            if (configCategory.getDestination() == null) {
                configCategory.destination = configBase.getNameAndCategory();
            }
            if (configBase.get() == null) continue;
            this.initNestedClass((Class)configCategory.get(), configCategory.getDestination());
        }
    }

    private static boolean isAcceptableType(Class<?> inputClass) {
        if (inputClass.isEnum()) {
            return true;
        }
        return ACCEPTABLE_INPUTS.contains(inputClass);
    }

    public String generateLang(boolean onlyShowMissing, boolean checkEnums) {
        ILangWrapper langWrapper = SingletonInjector.INSTANCE.get(ILangWrapper.class);
        ArrayList enumList = new ArrayList();
        String generatedLang = "";
        String starter = "  \"";
        String separator = "\":\n    \"";
        String ending = "\",\n";
        for (AbstractConfigBase<?> abstractConfigBase : this.configBaseList) {
            String entryPrefix = "distanthorizons.config." + abstractConfigBase.getNameAndCategory();
            if (checkEnums && abstractConfigBase.getType().isEnum() && !enumList.contains(abstractConfigBase.getType())) {
                enumList.add(abstractConfigBase.getType());
            }
            if (!abstractConfigBase.getAppearance().showInGui || ConfigUiLinkedEntry.class.isAssignableFrom(abstractConfigBase.getClass()) || ConfigUISpacer.class.isAssignableFrom(abstractConfigBase.getClass())) continue;
            if (ConfigUIComment.class.isAssignableFrom(abstractConfigBase.getClass()) && ((ConfigUIComment)abstractConfigBase).parentConfigPath != null) {
                entryPrefix = "distanthorizons.config." + ((ConfigUIComment)abstractConfigBase).parentConfigPath;
            }
            if (langWrapper.langExists(entryPrefix) && onlyShowMissing) continue;
            generatedLang = generatedLang + starter + entryPrefix + separator + langWrapper.getLang(entryPrefix) + ending;
            if (langWrapper.langExists(entryPrefix + ".@tooltip") && onlyShowMissing) continue;
            generatedLang = generatedLang + starter + entryPrefix + ".@tooltip" + separator + langWrapper.getLang(entryPrefix + ".@tooltip").replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\"") + ending;
        }
        if (!enumList.isEmpty()) {
            generatedLang = generatedLang + "\n";
            for (Class clazz : enumList) {
                for (Object enumStr : new ArrayList(EnumSet.allOf(clazz))) {
                    String enumPrefix = "distanthorizons.config.enum." + clazz.getSimpleName() + "." + enumStr.toString();
                    if (langWrapper.langExists(enumPrefix) && onlyShowMissing) continue;
                    generatedLang = generatedLang + starter + enumPrefix + separator + langWrapper.getLang(enumPrefix) + ending;
                }
            }
        }
        return generatedLang;
    }
}

