/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.WeatherParticle;

public class MistParticle
extends WeatherParticle {
    private MistParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z, ConfigManager.config.mist.renderStyle.getSprite());
        this.f_107213_ = (float)((int)y) + this.f_107223_.m_188501_();
        this.f_107663_ = ConfigManager.config.mist.size;
        this.m_107250_(this.f_107663_, 0.2f);
        this.targetOpacity = ConfigManager.config.mist.opacity;
        this.f_107225_ = ConfigManager.config.mist.lifetime;
        this.f_107230_ = 0.0f;
        Color color = VersionUtil.getFogColor((Level)level, (BlockPos)this.pos);
        this.f_107227_ = (float)color.getRed() / 255.0f;
        this.f_107228_ = (float)color.getGreen() / 255.0f;
        this.f_107229_ = (float)color.getBlue() / 255.0f;
        this.f_107204_ = this.f_107231_ = 1.5707964f * (float)level.f_46441_.m_188503_(4);
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        int halfLife = this.f_107225_ / 2;
        this.f_107230_ = (this.f_107224_ < halfLife ? (float)this.f_107224_ / (float)halfLife : (float)(-this.f_107224_ + this.f_107225_) / (float)halfLife) * ConfigManager.config.mist.opacity;
        if (ConfigManager.config.mist.renderStyle == ConfigData.MistOptions.RenderStyle.DITHERED) {
            this.f_107663_ = this.distance * 0.1f * ConfigManager.config.mist.size;
        }
        if (this.distance > (float)ConfigManager.config.perf.surfaceRange) {
            this.m_107274_();
        }
    }

    @Override
    public void tickDistanceFade() {
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ConfigManager.config.mist.renderStyle.getRenderType();
    }

    public void m_5744_(VertexConsumer h, Camera camera, float tickPercent) {
        Vec3 camPos = VersionUtil.camPos(camera);
        float x = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d(1.5707963705062866, -1.0, 0.0, 0.0));
        quaternion.rotateZ(Mth.m_14179_((float)tickPercent, (float)this.f_107204_, (float)this.f_107231_));
        this.turnBackfaceFlipways(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(h, quaternion, x, y, z, tickPercent);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new MistParticle(level, x, y, z, this.provider);
        }
    }
}

