/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.loaders.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.MistParticle;
import pigcart.particlerain.particle.RippleParticle;
import pigcart.particlerain.particle.ShrubParticle;
import pigcart.particlerain.particle.StreakParticle;

@Mod(value="particlerain")
public class ForgeEntrypoint {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256890_, (String)"particlerain");
    public static final RegistryObject<SimpleParticleType> SHRUB = ForgeEntrypoint.registerParticle("shrub");
    public static final RegistryObject<SimpleParticleType> MIST = ForgeEntrypoint.registerParticle("mist");
    public static final RegistryObject<SimpleParticleType> RIPPLE = ForgeEntrypoint.registerParticle("ripple");
    public static final RegistryObject<SimpleParticleType> STREAK = ForgeEntrypoint.registerParticle("streak");

    private static RegistryObject<SimpleParticleType> registerParticle(String name) {
        return PARTICLE_TYPES.register(name, () -> new SimpleParticleType(true));
    }

    public static void onTick(TickEvent.ClientTickEvent event) {
        ParticleRain.onTick(Minecraft.m_91087_());
    }

    public static void onRegisterCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register(ParticleRain.getCommands());
    }

    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SHRUB.get(), ShrubParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)MIST.get(), MistParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)RIPPLE.get(), RippleParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)STREAK.get(), StreakParticle.DefaultFactory::new);
        ParticleRain.SHRUB = (SimpleParticleType)SHRUB.get();
        ParticleRain.MIST = (SimpleParticleType)MIST.get();
        ParticleRain.RIPPLE = (SimpleParticleType)RIPPLE.get();
        ParticleRain.STREAK = (SimpleParticleType)STREAK.get();
        ConfigManager.updateTransientVariables();
    }

    public ForgeEntrypoint() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(ForgeEntrypoint::onTick);
        MinecraftForge.EVENT_BUS.addListener(ForgeEntrypoint::onRegisterCommands);
        PARTICLE_TYPES.register(eventBus);
        eventBus.addListener(ForgeEntrypoint::onRegisterParticleProviders);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ConfigManager.screenPlease(parent)));
        ParticleRain.onInitializeClient();
    }
}

