/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config.gui;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.gui.AbstractWidgetAccess;
import pigcart.particlerain.config.gui.Annotations;
import pigcart.particlerain.config.gui.ConfigScreen;
import pigcart.particlerain.config.gui.InputWidget;
import pigcart.particlerain.config.gui.LabelWidget;

public class Widgets {
    public static final int BUTTON_WIDTH = 150;
    public static final int BIG_BUTTON_WIDTH = 310;
    public static final int BUTTON_HEIGHT = 20;

    public static LabelWidget getLabel(Component message) {
        return new LabelWidget(310, 20, message);
    }

    public static LabelWidget getOptionLabel(Component message) {
        return new LabelWidget(150, 20, message).alignRight();
    }

    public static AbstractWidget getBool(String name, boolean initialValue, Consumer<Boolean> onValueChange, Function<Object, Component> valueFormatter) {
        return new CycleButton.Builder(valueFormatter).m_168948_((Object)initialValue).m_168961_(new Object[]{initialValue, !initialValue}).m_168936_(0, 0, 310, 20, (Component)Component.m_237115_((String)name), (widget, value) -> onValueChange.accept((Boolean)value));
    }

    public static AbstractWidget getBool(String name, boolean initialValue, Consumer<Boolean> onValueChange) {
        return Widgets.getBool(name, initialValue, onValueChange, value -> (Boolean)value != false ? CommonComponents.f_130653_.m_6881_().m_130940_(ChatFormatting.GREEN) : CommonComponents.f_130654_.m_6881_().m_130940_(ChatFormatting.RED));
    }

    public static AbstractWidget getEnum(String name, boolean displayOnlyValue, Object initialValue, Consumer<Object> onValueChange) {
        Object[] values = initialValue.getClass().getEnumConstants();
        if (values == null) {
            values = initialValue.getClass().getEnclosingClass().getEnumConstants();
        }
        CycleButton.Builder builder = new CycleButton.Builder(value -> {
            String className = value.getClass().getSimpleName();
            if (className.isEmpty()) {
                className = value.getClass().getEnclosingClass().getSimpleName();
            }
            return Component.m_237115_((String)("particlerain." + className + "." + String.valueOf(value)));
        }).m_168948_(initialValue).m_168961_(values);
        if (displayOnlyValue) {
            builder.m_168929_();
        }
        return builder.m_168936_(0, 0, 310, 20, (Component)Component.m_237115_((String)name), (widget, value) -> onValueChange.accept(value));
    }

    public static AbstractWidget getFloat(int width, int x, String name, float initialValue, Consumer<Float> onValueChange, Function<Object, Component> valueFormatter) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(6);
        InputWidget inputWidget = new InputWidget(width, x, df.format(initialValue), string -> onValueChange.accept(Float.valueOf(string)), valueFormatter);
        inputWidget.setFilter(InputWidget.NON_FLOAT);
        inputWidget.m_93666_((Component)Component.m_237115_((String)name));
        return inputWidget;
    }

    public static AbstractWidget getInt(int width, int x, String name, int initialValue, Consumer<Integer> onValueChange, Function<Object, Component> valueFormatter) {
        InputWidget inputWidget = new InputWidget(width, x, String.valueOf(initialValue), string -> onValueChange.accept(Integer.valueOf(string)), valueFormatter);
        inputWidget.setFilter(InputWidget.NON_INTEGER);
        inputWidget.m_93666_((Component)Component.m_237115_((String)name));
        return inputWidget;
    }

    public static AbstractWidget getString(int width, int x, String name, String initialValue, Consumer<String> onValueChange, Function<Object, Component> valueFormatter) {
        InputWidget inputWidget = new InputWidget(width, x, String.valueOf(initialValue), onValueChange, valueFormatter);
        inputWidget.setFilter(InputWidget.NON_PATH);
        inputWidget.m_93666_((Component)Component.m_237115_((String)name));
        return inputWidget;
    }

    public static AbstractWidget getButton(Component name, Button.OnPress onPress) {
        return Button.m_253074_((Component)name, (Button.OnPress)onPress).m_252987_(0, 0, 310, 20).m_253136_();
    }

    public static AbstractWidget getSlider(final String name, float initialValue, final Consumer<Float> onValueChange, final float min, final float max, final float step, final Function<Object, Component> valueFormatter) {
        return new AbstractSliderButton(0, 0, 310, 20, (Component)Component.m_237115_((String)name).m_130946_(": ").m_7220_(valueFormatter.apply(Float.valueOf(initialValue))), Mth.m_14179_((float)initialValue, (float)min, (float)max)){

            protected void m_5695_() {
                this.m_93666_((Component)Component.m_237115_((String)name).m_130946_(": ").m_7220_((Component)valueFormatter.apply(this.f_93577_)));
            }

            protected void m_5697_() {
                onValueChange.accept(Float.valueOf((float)Math.round(Mth.m_14139_((double)this.f_93577_, (double)min, (double)max) / (double)step) * step));
            }
        };
    }

    public static AbstractWidget[] getHexColor(int width, int x, String name, Object initialValue, Consumer<Object> onValueChange, Function<Object, Component> valueFormatter) {
        String value = ConfigManager.ColorTypeAdapter.getString((Color)initialValue);
        Consumer<String> onChange = string -> {
            Color color = ConfigManager.ColorTypeAdapter.getColor(string);
            onValueChange.accept(color);
        };
        InputWidget input = (InputWidget)Widgets.getString(width, x, name, value, onChange, valueFormatter);
        input.setFilter(InputWidget.NON_HEX);
        return new AbstractWidget[]{Widgets.getOptionLabel((Component)Component.m_237115_((String)name).m_130946_(":")), input};
    }

    public static void addOptionWidgets(ConfigScreen screen) {
        Field[] fields;
        if (screen.config instanceof List) {
            Widgets.addListOptions(screen, (List)screen.config, (List)screen.configDefault, screen.configGenericType);
            return;
        }
        for (Field field : fields = screen.config.getClass().getFields()) {
            Object defaultValue;
            Object currentValue;
            if (field.isAnnotationPresent(Annotations.NoGUI.class)) continue;
            if (field.isAnnotationPresent(Annotations.OnlyVisibleIf.class)) {
                Annotations.OnlyVisibleIf annotation = field.getAnnotation(Annotations.OnlyVisibleIf.class);
                try {
                    Function function = (Function)annotation.value().getConstructors()[0].newInstance(new Object[0]);
                    boolean optionIsVisible = (Boolean)function.apply(screen.config);
                    if (!optionIsVisible) {
                        continue;
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (field.isAnnotationPresent(Annotations.Label.class)) {
                AbstractWidget[] widgets = new AbstractWidget[]{Widgets.getLabel((Component)Component.m_237115_((String)field.getAnnotation(Annotations.Label.class).key()))};
                screen.add(widgets);
            }
            String name = "particlerain." + field.getName();
            field.setAccessible(true);
            Class<?> type = field.getType();
            try {
                currentValue = field.get(screen.config);
                defaultValue = field.get(screen.configDefault);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            Consumer<Object> onValueChange = value -> {
                try {
                    field.set(screen.config, value);
                    if (field.isAnnotationPresent(Annotations.OnChange.class)) {
                        Annotations.OnChange onChange = field.getAnnotation(Annotations.OnChange.class);
                        ((Runnable)onChange.value().getConstructors()[0].newInstance(new Object[0])).run();
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            Function valueFormatter = value -> Component.m_237113_((String)value.toString());
            if (field.isAnnotationPresent(Annotations.Format.class)) {
                Annotations.Format format = field.getAnnotation(Annotations.Format.class);
                try {
                    valueFormatter = (Function)format.value().getConstructors()[0].newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (type.equals(ArrayList.class)) {
                Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                if (field.getName().equals("particles")) {
                    List particles = (List)currentValue;
                    for (int i = 0; i < particles.size(); i += 2) {
                        ConfigData.ParticleData leftParticle = (ConfigData.ParticleData)particles.get(i);
                        AbstractWidget left = Widgets.getBool("particlerain." + leftParticle.id, leftParticle.enabled, value -> {
                            leftParticle.enabled = value;
                        });
                        left.m_93674_(150);
                        if (i < particles.size() - 1) {
                            ConfigData.ParticleData rightParticle = (ConfigData.ParticleData)particles.get(i + 1);
                            AbstractWidget right = Widgets.getBool("particlerain." + rightParticle.id, rightParticle.enabled, value -> {
                                rightParticle.enabled = value;
                            });
                            ((AbstractWidgetAccess)right).particle_rain$setOffset(left.m_5711_() + 8);
                            right.m_93674_(150);
                            screen.add(left, right);
                            continue;
                        }
                        screen.add(left);
                    }
                } else if (field.isAnnotationPresent(Annotations.NoSubMenu.class)) {
                    Widgets.addListOptions(screen, (List)currentValue, (List)defaultValue, listType);
                    continue;
                }
                AbstractWidget[] widgets = new AbstractWidget[]{Widgets.getButton((Component)Component.m_237115_((String)name).m_130946_("..."), bttn -> Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(screen.getFreshScreen(), currentValue, defaultValue, listType, (Component)Component.m_237115_((String)name))))};
                screen.add(widgets);
                continue;
            }
            AbstractWidget[] widgets = Widgets.getOptionWidget(screen, field, name, currentValue, defaultValue, onValueChange, valueFormatter, type);
            screen.add(widgets);
        }
        Widgets.appendBespokeParticleOptions(screen);
    }

    private static AbstractWidget[] getOptionWidget(ConfigScreen screen, Field field, String name, Object currentValue, Object defaultValue, Consumer onValueChange, Function<Object, Component> valueFormatter, Class<?> type) {
        if (field.isAnnotationPresent(Annotations.Slider.class)) {
            Annotations.Slider slider = field.getAnnotation(Annotations.Slider.class);
            return new AbstractWidget[]{Widgets.getSlider(name, ((Float)currentValue).floatValue(), onValueChange, slider.min(), slider.max(), slider.step(), valueFormatter)};
        }
        if (type.equals(Boolean.TYPE)) {
            if (field.isAnnotationPresent(Annotations.BooleanFormat.class)) {
                Annotations.BooleanFormat format = field.getAnnotation(Annotations.BooleanFormat.class);
                MutableComponent t = Component.m_237115_((String)("particlerain." + format.t()));
                MutableComponent f = Component.m_237115_((String)("particlerain." + format.f()));
                valueFormatter = arg_0 -> Widgets.lambda$getOptionWidget$12((Component)t, (Component)f, arg_0);
                return new AbstractWidget[]{Widgets.getBool(name, (Boolean)currentValue, onValueChange, valueFormatter)};
            }
            return new AbstractWidget[]{Widgets.getBool(name, (Boolean)currentValue, onValueChange)};
        }
        if (type.equals(Float.TYPE)) {
            return new AbstractWidget[]{Widgets.getOptionLabel((Component)Component.m_237115_((String)name).m_130946_(":")), Widgets.getFloat(150, 158, "", ((Float)currentValue).floatValue(), onValueChange, valueFormatter)};
        }
        if (type.equals(Integer.TYPE)) {
            return new AbstractWidget[]{Widgets.getOptionLabel((Component)Component.m_237115_((String)name).m_130946_(":")), Widgets.getInt(150, 158, name, (Integer)currentValue, onValueChange, valueFormatter)};
        }
        if (type.equals(String.class)) {
            return new AbstractWidget[]{Widgets.getOptionLabel((Component)Component.m_237115_((String)name).m_130946_(":")), Widgets.getString(150, 158, name, (String)currentValue, onValueChange, valueFormatter)};
        }
        if (type.isEnum()) {
            return new AbstractWidget[]{Widgets.getEnum(name, false, currentValue, onValueChange)};
        }
        if (type.equals(URI.class)) {
            return new AbstractWidget[]{Widgets.getButton((Component)Component.m_237115_((String)name), bttn -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(result -> {
                if (result) {
                    VersionUtil.openUri((URI)currentValue);
                }
                Minecraft.m_91087_().m_91152_((Screen)screen);
            }, currentValue.toString(), true)))};
        }
        if (type.equals(Color.class)) {
            return Widgets.getHexColor(310, 0, name, currentValue, onValueChange, valueFormatter);
        }
        if (type.getFields().length > 0) {
            return new AbstractWidget[]{Widgets.getButton((Component)Component.m_237115_((String)name).m_130946_("..."), bttn -> Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(screen, currentValue, defaultValue, (Component)Component.m_237115_((String)name))))};
        }
        ParticleRain.LOGGER.error("Unable to create option for field {}", (Object)field.getName());
        return new AbstractWidget[]{Widgets.getLabel((Component)Component.m_237113_((String)("Unable to create option for field " + field.getName())))};
    }

    private static <E> void addListOptions(ConfigScreen screen, List<E> list, List<?> defaultList, Class<?> listEntryType) {
        if (list.isEmpty()) {
            screen.add(new AbstractWidget[]{Widgets.getLabel((Component)Component.m_237115_((String)"mco.configure.world.slot.empty"))});
        }
        int i = 0;
        while (i < list.size()) {
            E entry = list.get(i);
            Object defaultEntry = i < defaultList.size() ? defaultList.get(i) : Widgets.getNewValue(listEntryType);
            int index = i++;
            Consumer<Object> onValueChange = value -> list.set(index, value);
            AbstractWidget listEntryWidget = Widgets.getListEntryWidget(screen, listEntryType, String.valueOf(index + 1), entry, defaultEntry, onValueChange);
            AbstractWidget removeButton = Widgets.getButton((Component)Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.RED), bttn -> {
                list.remove(index);
                screen.refresh();
            });
            listEntryWidget.m_93674_(288);
            removeButton.m_93674_(20);
            ((AbstractWidgetAccess)removeButton).particle_rain$setOffset(290);
            screen.add(listEntryWidget, removeButton);
        }
        MutableComponent addButtonText = Component.m_237115_((String)"particlerain.addNew");
        AbstractWidget addButton = Widgets.getButton((Component)addButtonText, bttn -> {
            Object newListEntry = Widgets.getNewValue(listEntryType);
            Object defaultEntry = Widgets.getNewValue(listEntryType);
            list.add(newListEntry);
            if (listEntryType.equals(ConfigData.ParticleData.class)) {
                Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(screen.getFreshScreen(), newListEntry, defaultEntry, (Component)addButtonText));
            } else {
                screen.refresh();
            }
        });
        if (!(list instanceof ArrayList)) {
            addButton.f_93623_ = false;
        }
        screen.add(addButton);
    }

    private static AbstractWidget getListEntryWidget(ConfigScreen screen, Class<?> type, String name, Object entry, Object defaultEntry, Consumer onValueChange) {
        if (type.equals(String.class)) {
            return Widgets.getString(310, 0, name, (String)entry, onValueChange, value -> Component.m_237113_((String)value.toString()));
        }
        if (type.equals(ConfigData.ParticleData.class)) {
            String particleKey = "particlerain." + ((ConfigData.ParticleData)entry).id;
            return Widgets.getButton((Component)Component.m_237115_((String)particleKey), bttn -> Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(screen.getFreshScreen(), entry, defaultEntry, (Component)Component.m_237115_((String)particleKey))));
        }
        if (type.isEnum()) {
            return Widgets.getEnum(name, true, entry, onValueChange);
        }
        return Widgets.getLabel((Component)Component.m_237113_((String)(type.getSimpleName() + " unimplemented")));
    }

    private static Object getNewValue(Class<?> type) {
        if (type.isEnum()) {
            return type.getEnumConstants()[0];
        }
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ParticleRain.LOGGER.error("Couldn't get new value for: {}", (Object)type.getSimpleName());
            throw new RuntimeException(e);
        }
    }

    private static void appendBespokeParticleOptions(ConfigScreen screen) {
        try {
            Object object = screen.config;
            if (object instanceof ConfigData.ParticleData) {
                String configId;
                ConfigData.ParticleData particleData = (ConfigData.ParticleData)object;
                if (particleData.usePresetParticle && ParticleRain.particleConfigIds.contains(configId = VersionUtil.parseId(particleData.presetParticleId).m_135815_())) {
                    Field f = ConfigData.class.getField(configId);
                    f.setAccessible(true);
                    Object bespokeParticleConfig = f.get(ConfigManager.config);
                    Object defaultConfig = f.get(ConfigManager.getDefaultConfig());
                    AbstractWidget button = Widgets.getButton((Component)Component.m_237115_((String)"particlerain.appearance"), bttn -> Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(screen, bespokeParticleConfig, defaultConfig, (Component)Component.m_237115_((String)"particlerain.appearance"))));
                    screen.list.add(button);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ Component lambda$getOptionWidget$12(Component t, Component f, Object value) {
        return (Boolean)value != false ? t : f;
    }
}

