/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config.gui;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import pigcart.particlerain.config.gui.AbstractWidgetAccess;

public class InputWidget
extends EditBox {
    String unformattedValue;
    Function<Object, Component> valueFormatter;
    Pattern filteredChars;
    public static final Pattern NON_INTEGER = Pattern.compile("[^0-9]");
    public static final Pattern NON_FLOAT = Pattern.compile("[^0-9.]");
    public static final Pattern NON_PATH = Pattern.compile("[^a-z0-9:/._-]");
    public static final Pattern NON_HEX = Pattern.compile("[^a-fA-F0-9#]");

    public InputWidget(int width, int x, String initialValue, Consumer<String> onValueChange, Function<Object, Component> valueFormatter) {
        super(Minecraft.m_91087_().f_91062_, 0, 0, width, 20, (Component)Component.m_237119_());
        ((AbstractWidgetAccess)((Object)this)).particle_rain$setOffset(x);
        this.unformattedValue = initialValue;
        this.valueFormatter = valueFormatter;
        this.m_94151_(value -> {
            if (!this.m_93696_()) {
                return;
            }
            this.unformattedValue = value;
            try {
                onValueChange.accept((String)value);
                this.m_94202_(0xE0E0E0);
            }
            catch (NumberFormatException ignored) {
                this.m_94202_(-43691);
            }
        });
        this.format();
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        this.format();
    }

    public void format() {
        if (this.m_93696_()) {
            this.forceSetValue(this.unformattedValue);
        } else {
            this.forceSetValue(this.valueFormatter.apply(this.unformattedValue).getString());
        }
    }

    public void forceSetValue(String value) {
        this.f_94093_ = value;
        this.m_94201_();
        this.m_94208_(this.m_94207_());
    }

    public void setFilter(Pattern pattern) {
        this.filteredChars = pattern;
        if (this.filteredChars != null) {
            this.m_94153_(string -> !this.filteredChars.matcher((CharSequence)string).find());
        } else {
            this.m_94153_(Objects::nonNull);
        }
    }
}

