/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.datafix;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.data.DataFixerStorage;
import io.redspace.ironsspellbooks.datafix.DataFixerHelpers;
import io.redspace.ironsspellbooks.datafix.IronsTagTraverser;
import io.redspace.ironsspellbooks.datafix.ParallelMatcher;
import io.redspace.ironsspellbooks.util.ByteHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.storage.LevelStorageSource;

public class IronsWorldUpgrader {
    public int tempCount = 0;
    public static int IRONS_WORLD_DATA_VERSION = 2;
    final int REPORT_PROGRESS_MS = 5000;
    public static final byte[] INHABITED_TIME_MARKER = new byte[]{73, 110, 104, 97, 98, 105, 116, 101, 100, 84, 105, 109, 101};
    public static final String REGION_FOLDER = "region";
    public static final String ENTITY_FOLDER = "entities";
    private final LevelStorageSource.LevelStorageAccess levelStorage;
    private final DataFixer dataFixer;
    private int converted;
    private int skipped;
    private int fixes;
    private boolean running;
    private static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private Set<ResourceKey<Level>> levels = null;

    public IronsWorldUpgrader(LevelStorageSource.LevelStorageAccess pLevelStorage, LayeredRegistryAccess<RegistryLayer> registries) {
        this.levelStorage = pLevelStorage;
        try {
            this.levels = registries.m_247579_().m_175515_(Registries.f_256862_).m_214010_().stream().map(Registries::m_257551_).collect(Collectors.toUnmodifiableSet());
        }
        catch (Exception exception) {
            IronsSpellbooks.LOGGER.error("IronsWorldUpgrader. Failed to init levels. Cannot upgrade", (Throwable)exception);
        }
        this.dataFixer = new DataFixerBuilder(1).buildUnoptimized();
    }

    public boolean worldNeedsUpgrading() {
        return DataFixerStorage.INSTANCE.getDataVersion() < IRONS_WORLD_DATA_VERSION;
    }

    public void runUpgrade() {
        if (this.levels != null && this.worldNeedsUpgrading()) {
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader starting upgrade");
            long millis = 0L;
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader starting ENTITY_FOLDER");
            millis = Util.m_137550_();
            this.doWork(ENTITY_FOLDER, null, false, false);
            millis = Util.m_137550_() - millis;
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader finished ENTITY_FOLDER after {} ms.  chunks updated:{} chunks skipped:{} tags fixed:{}", new Object[]{millis, this.converted, this.skipped, this.fixes});
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader starting REGION_FOLDER (this will take a few minutes on huge worlds..");
            millis = Util.m_137550_();
            this.doWork(REGION_FOLDER, "block_entities", true, true);
            millis = Util.m_137550_() - millis;
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader finished REGION_FOLDER after {} ms.  chunks updated:{} chunks skipped:{} tags fixed:{}", new Object[]{millis, this.converted, this.skipped, this.fixes});
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader starting fixDimensionStorage");
            millis = Util.m_137550_();
            this.fixDimensionStorage();
            millis = Util.m_137550_() - millis;
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader finished fixDimensionStorage after {} ms. tags fixed:{} ", (Object)millis, (Object)this.fixes);
            int previousVersion = DataFixerStorage.INSTANCE.getDataVersion();
            DataFixerStorage.INSTANCE.setDataVersion(IRONS_WORLD_DATA_VERSION);
            IronsSpellbooks.LOGGER.info("IronsWorldUpgrader V{} -> V{} completed", (Object)previousVersion, (Object)IRONS_WORLD_DATA_VERSION);
        }
    }

    private void fixDimensionStorage() {
        this.running = true;
        this.converted = 0;
        this.skipped = 0;
        this.fixes = 0;
        this.levels.stream().map(resourceKey -> this.levelStorage.m_197394_(resourceKey).resolve("data").toFile()).forEach(dir -> {
            File[] files = dir.listFiles();
            if (files != null) {
                Arrays.stream(files).toList().forEach(this::fixDimensionDataFile);
            }
        });
    }

    private void fixDimensionDataFile(File file) {
        File[] subFiles = file.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            Arrays.stream(subFiles).forEach(this::fixDimensionDataFile);
        } else {
            try {
                CompoundTag compoundTag = NbtIo.m_128937_((File)file);
                IronsTagTraverser ironsTraverser = new IronsTagTraverser();
                ironsTraverser.visit((Tag)compoundTag);
                if (ironsTraverser.changesMade()) {
                    NbtIo.m_128944_((CompoundTag)compoundTag, (File)file);
                }
                this.fixes += ironsTraverser.totalChanges();
            }
            catch (Exception exception) {
                IronsSpellbooks.LOGGER.error("IronsWorldUpgrader FixDimensionStorage error: {}", (Object)exception.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean preScanChunkUpdateNeeded(ChunkStorage chunkStorage, ChunkPos chunkPos) throws Exception {
        RegionFile regionFile = chunkStorage.f_63495_.f_63518_.m_63711_(chunkPos);
        DataInputStream dataInputStream = regionFile.m_63645_(chunkPos);
        try (DataInputStream dataInputStream2 = dataInputStream;){
            if (dataInputStream == null) {
                boolean bl = false;
                return bl;
            }
            int markerPos = ByteHelper.indexOf(dataInputStream, new ParallelMatcher(DataFixerHelpers.DATA_MATCHER_TARGETS));
            if (markerPos == -1) {
                boolean bl = true;
                return bl;
            }
            long inhabitedTime = dataInputStream.readLong();
            ++this.tempCount;
            boolean bl = inhabitedTime != 0L;
            return bl;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void doWork(String regionFolder, String filterTag, boolean preScan, boolean checkInhabitedTime) {
        this.running = true;
        this.converted = 0;
        this.skipped = 0;
        this.fixes = 0;
        long nextProgressReportMS = System.currentTimeMillis() + 5000L;
        int totalChunks = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceKey<Level> resourcekey : this.levels) {
            List<ChunkPos> list = this.getAllChunkPos(resourcekey, regionFolder);
            builder.put(resourcekey, list.listIterator());
            totalChunks += list.size();
        }
        if (totalChunks > 0) {
            ImmutableMap immutablemap = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            for (ResourceKey resourceKey : this.levels) {
                Path path = this.levelStorage.m_197394_(resourceKey);
                builder1.put((Object)resourceKey, (Object)new ChunkStorage(path.resolve(regionFolder), this.dataFixer, true));
            }
            ImmutableMap immutablemap1 = builder1.build();
            while (this.running) {
                boolean bl;
                boolean bl2 = false;
                for (ResourceKey resourceKey : this.levels) {
                    ListIterator listiterator = (ListIterator)immutablemap.get((Object)resourceKey);
                    ChunkStorage chunkstorage = (ChunkStorage)immutablemap1.get((Object)resourceKey);
                    if (!listiterator.hasNext()) continue;
                    ChunkPos chunkpos = (ChunkPos)listiterator.next();
                    boolean updated = false;
                    try {
                        CompoundTag chunkDataTag;
                        if (!(preScan && !this.preScanChunkUpdateNeeded(chunkstorage, chunkpos) || (chunkDataTag = (CompoundTag)((Optional)chunkstorage.m_223454_(chunkpos).join()).orElse(null)) == null || checkInhabitedTime && chunkDataTag.m_128451_("InhabitedTime") == 0)) {
                            ListTag blockEntitiesTag;
                            if (filterTag != null) {
                                blockEntitiesTag = (ListTag)chunkDataTag.m_128423_(filterTag);
                            } else {
                                blockEntitiesTag = new ListTag();
                                blockEntitiesTag.add((Object)chunkDataTag);
                            }
                            IronsTagTraverser ironsTagTraverser = new IronsTagTraverser();
                            ironsTagTraverser.visit((Tag)blockEntitiesTag);
                            if (ironsTagTraverser.changesMade()) {
                                chunkstorage.m_63502_(chunkpos, chunkDataTag);
                                this.fixes += ironsTagTraverser.totalChanges();
                                updated = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        IronsSpellbooks.LOGGER.error("IronsWorldUpgrader: Error upgrading chunk {}, {}", (Object)chunkpos, (Object)exception.getMessage());
                    }
                    if (updated) {
                        ++this.converted;
                    } else {
                        ++this.skipped;
                    }
                    if (System.currentTimeMillis() > nextProgressReportMS) {
                        nextProgressReportMS = System.currentTimeMillis() + 5000L;
                        int chunksProcessed = this.converted + this.skipped;
                        IronsSpellbooks.LOGGER.info("IronsWorldUpgrader {} PROGRESS: {} of {} chunks complete ({}%)", new Object[]{regionFolder, chunksProcessed, totalChunks, String.format("%.2f", Float.valueOf((float)chunksProcessed / (float)totalChunks * 100.0f))});
                    }
                    bl = true;
                }
                if (bl) continue;
                this.running = false;
            }
            for (ChunkStorage chunkstorage1 : immutablemap1.values()) {
                try {
                    chunkstorage1.close();
                }
                catch (IOException iOException) {
                    IronsSpellbooks.LOGGER.error("IronsWorldUpgrader: Error closing chunk storage: {}", (Object)iOException.getMessage());
                }
            }
        }
    }

    private List<ChunkPos> getAllChunkPos(ResourceKey<Level> p_18831_, String folder) {
        File file1 = this.levelStorage.m_197394_(p_18831_).toFile();
        File file2 = new File(file1, folder);
        File[] afile = file2.listFiles((p_18822_, p_18823_) -> p_18823_.endsWith(".mca"));
        if (afile == null) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        for (File file3 : afile) {
            Matcher matcher = REGEX.matcher(file3.getName());
            if (!matcher.matches()) continue;
            int i = Integer.parseInt(matcher.group(1)) << 5;
            int j = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionfile = new RegionFile(file3.toPath(), file2.toPath(), true);){
                for (int k = 0; k < 32; ++k) {
                    for (int l = 0; l < 32; ++l) {
                        ChunkPos chunkpos = new ChunkPos(k + i, l + j);
                        if (!regionfile.m_63673_(chunkpos)) continue;
                        list.add(chunkpos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }
}

