/*
 * Decompiled with CFR 0.152.
 */
package net.thetct.tctcore.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.thetct.tctcore.TctcoreMod;
import net.thetct.tctcore.init.TctcoreModScreens;
import net.thetct.tctcore.network.MenuStateUpdateMessage;
import net.thetct.tctcore.world.inventory.InstallModsMenu;
import net.thetct.tctcore.world.inventory.ModsSettingsMenu;
import net.thetct.tctcore.world.inventory.TCTcoreMenu;

public class TctcoreModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"tctcore");
    public static final RegistryObject<MenuType<TCTcoreMenu>> TC_TCORE = REGISTRY.register("tc_tcore", () -> IForgeMenuType.create(TCTcoreMenu::new));
    public static final RegistryObject<MenuType<ModsSettingsMenu>> MODS_SETTINGS = REGISTRY.register("mods_settings", () -> IForgeMenuType.create(ModsSettingsMenu::new));
    public static final RegistryObject<MenuType<InstallModsMenu>> INSTALL_MODS = REGISTRY.register("install_mods", () -> IForgeMenuType.create(InstallModsMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                TctcoreMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof TctcoreModScreens.ScreenAccessor) {
                    TctcoreModScreens.ScreenAccessor accessor = (TctcoreModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                TctcoreMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

