/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.platform;

import com.kekecreations.jinxedlib.core.platform.services.IRegistryHelper;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;

public class ForgeRegistryHelper
implements IRegistryHelper {
    IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    private static final RegistryMap registryMap = new RegistryMap();

    @Override
    public <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String modID, String id, Supplier<T> tabSupplier) {
        DeferredRegister tabRegistry = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)modID);
        tabRegistry.register(this.modEventBus);
        return tabRegistry.register(id, tabSupplier);
    }

    @Override
    public <T> Supplier<T> register(Registry<T> registry, String modid, String id, Supplier<T> supplier) {
        DeferredRegister objectRegistry = DeferredRegister.create((ResourceKey)registry.m_123023_(), (String)modid);
        objectRegistry.register(this.modEventBus);
        return objectRegistry.register(id, supplier);
    }

    private static class RegistryMap {
        private final Map<Pair<String, ResourceLocation>, DeferredRegister<?>> registries = new HashMap();

        private RegistryMap() {
        }

        private <T> RegistryObject<T> register(String modID, Registry<? super T> registry, String name, Supplier<T> entry) {
            DeferredRegister reg = this.registries.computeIfAbsent((Pair<String, ResourceLocation>)Pair.of((Object)modID, (Object)registry.m_123023_().m_135782_()), key -> {
                ForgeRegistry forgeReg = RegistryManager.ACTIVE.getRegistry((ResourceLocation)key.getSecond());
                if (forgeReg == null) {
                    return null;
                }
                DeferredRegister defReg = DeferredRegister.create((IForgeRegistry)forgeReg, (String)((String)key.getFirst()));
                defReg.register(FMLJavaModLoadingContext.get().getModEventBus());
                return defReg;
            });
            return reg != null ? reg.register(name, entry) : null;
        }
    }
}

