/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights;

import com.google.common.collect.Lists;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSources;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import toni.sodiumdynamiclights.DynamicLightSource;
import toni.sodiumdynamiclights.DynamicLightsConfig;
import toni.sodiumdynamiclights.accessor.WorldRendererAccessor;

@Mod(value="sodiumdynamiclights")
public class SodiumDynamicLights {
    public static final String NAMESPACE = "sodiumdynamiclights";
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private static SodiumDynamicLights INSTANCE;
    public final Logger logger = LoggerFactory.getLogger((String)"sodiumdynamiclights");
    public final DynamicLightsConfig config = new DynamicLightsConfig();
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;
    private static List<PreparableReloadListener> serverDataReloadListeners;

    public SodiumDynamicLights() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::clientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DynamicLightsConfig.SPECS);
    }

    public void onInitializeClient() {
        INSTANCE = this;
        this.log("Initializing SodiumDynamicLights...");
        SodiumDynamicLights.registerReloadListener(PackType.CLIENT_RESOURCES, new SimplePreparableReloadListener(){

            protected Object m_5944_(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void m_5787_(Object object, ResourceManager resourceManager, ProfilerFiller profiler) {
                ItemLightSources.load(resourceManager);
            }
        });
        DynamicLightHandlers.registerDefaultHandlers();
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }

    public static void registerReloadListener(PackType type, SimplePreparableReloadListener listener) {
        if (type == PackType.SERVER_DATA) {
            serverDataReloadListeners.add((PreparableReloadListener)listener);
        } else if (type == PackType.CLIENT_RESOURCES) {
            SodiumDynamicLights.registerClient((PreparableReloadListener)listener);
        }
    }

    private static void registerClient(PreparableReloadListener listener) {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_(listener);
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        for (PreparableReloadListener listener : serverDataReloadListeners) {
            event.addListener(listener);
        }
    }

    public void updateAll(@NotNull LevelRenderer renderer) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            this.lightSourcesLock.readLock().lock();
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.sodiumdynamiclights$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
            this.lightSourcesLock.readLock().unlock();
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull Entity entity, int lightmap) {
        int posLightLevel = (int)this.getDynamicLightLevel(entity.m_20097_());
        int entityLuminance = ((DynamicLightSource)entity).sdl$getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightTexture.m_109883_((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (DynamicLightSource lightSource : this.dynamicLightSources) {
            result = SodiumDynamicLights.maxDynamicLightLevel(pos, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return Mth.m_14008_((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull DynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.sdl$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.m_123341_() - lightSource.sdl$getDynamicLightX() + 0.5) * dx + (dy = (double)pos.m_123342_() - lightSource.sdl$getDynamicLightY() + 0.5) * dy + (dz = (double)pos.m_123343_() - lightSource.sdl$getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.sdl$getDynamicLightLevel().m_5776_()) {
            return;
        }
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.lightSourcesLock.writeLock().lock();
        this.dynamicLightSources.add(lightSource);
        this.lightSourcesLock.writeLock().unlock();
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.sdl$getDynamicLightLevel().m_5776_()) {
            return false;
        }
        this.lightSourcesLock.readLock().lock();
        boolean result = this.dynamicLightSources.contains(lightSource);
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        this.lightSourcesLock.readLock().lock();
        int result = this.dynamicLightSources.size();
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            lightSource.sodiumdynamiclights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void clearLightSources() {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (it.sdl$getLuminance() > 0) {
                it.sdl$resetDynamicLight();
            }
            it.sodiumdynamiclights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (it.sdl$getLuminance() > 0) {
                it.sdl$resetDynamicLight();
            }
            it.sodiumdynamiclights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof Entity && !(lightSource instanceof Player));
    }

    public void removeCreeperLightSources() {
        this.removeLightSources(entity -> entity instanceof Creeper);
    }

    public void removeTntLightSources() {
        this.removeLightSources(entity -> entity instanceof PrimedTnt);
    }

    public void removeBlockEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof BlockEntity);
    }

    public void log(String info) {
        this.logger.info("[LambDynLights] " + info);
    }

    public void warn(String info) {
        this.logger.warn("[LambDynLights] " + info);
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        SodiumDynamicLights.scheduleChunkRebuild(renderer, chunkPos.m_123341_(), chunkPos.m_123342_(), chunkPos.m_123343_());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        SodiumDynamicLights.scheduleChunkRebuild(renderer, BlockPos.m_121983_((long)chunkPos), BlockPos.m_122008_((long)chunkPos), BlockPos.m_122015_((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            ((WorldRendererAccessor)renderer).sodiumdynamiclights$scheduleChunkRebuild(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.m_121878_();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.sdl$isDynamicLightEnabled();
        int luminance = lightSource.sdl$getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.sdl$setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.sdl$setDynamicLightEnabled(false);
        }
    }

    private static boolean isEyeSubmergedInFluid(LivingEntity entity) {
        if (!((Boolean)SodiumDynamicLights.get().config.getWaterSensitiveCheck().get()).booleanValue()) {
            return false;
        }
        BlockPos eyePos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_());
        return !entity.m_9236_().m_6425_(eyePos).m_76178_();
    }

    public static int getLivingEntityLuminanceFromItems(LivingEntity entity) {
        boolean submergedInFluid = SodiumDynamicLights.isEyeSubmergedInFluid(entity);
        int luminance = 0;
        for (ItemStack equipped : entity.m_20158_()) {
            if (equipped.m_41619_()) continue;
            luminance = Math.max(luminance, SodiumDynamicLights.getLuminanceFromItemStack(equipped, submergedInFluid));
        }
        return luminance;
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack, boolean submergedInWater) {
        return ItemLightSources.getLuminance(stack, submergedInWater);
    }

    public static SodiumDynamicLights get() {
        return INSTANCE;
    }

    static {
        serverDataReloadListeners = Lists.newArrayList();
    }
}

