/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.io.Serializable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiMinimapSettings;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.common.config.option.ConfigOption;

public class GuiSlimeSeed
extends GuiMinimapSettings {
    public EditBox seedTextField;
    private final MinimapWorld minimapWorld;
    private final IXaeroMinimap modMain;
    private final MinimapSession session;

    public GuiSlimeSeed(IXaeroMinimap modMain, MinimapSession session, Screen parent, Screen escape, IEditConfigScreenContext context) {
        super((Component)Component.m_237115_((String)"gui.xaero_slime_chunks"), parent, escape, context);
        this.modMain = modMain;
        this.session = session;
        this.entries = new ISettingEntry[]{this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.SLIME_CHUNKS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.OPEN_SLIME_CHUNKS_SCREEN)};
        this.minimapWorld = session.getWorldManager().getCurrentWorld();
    }

    public void m_7856_() {
        super.m_7856_();
        this.seedTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 68, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_used_seed"));
        this.seedTextField.m_94144_("" + (Serializable)(this.minimapWorld.getSlimeChunkSeed() == null ? "" : this.minimapWorld.getSlimeChunkSeed()));
        this.m_142416_((GuiEventListener)this.seedTextField);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.seedTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"gui.xaero_used_seed", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ / 7 + 55, 0xFFFFFF);
    }

    public void m_86600_() {
        this.seedTextField.m_94120_();
    }

    @Override
    public boolean m_7933_(int par1, int par2, int par3) {
        boolean result = super.m_7933_(par1, par2, par3);
        if (par1 == 257) {
            this.goBack();
        }
        this.updateSlimeSeed();
        return result;
    }

    public boolean m_5534_(char par1, int par2) {
        boolean result = super.m_5534_(par1, par2);
        this.updateSlimeSeed();
        return result;
    }

    private void updateSlimeSeed() {
        String s = this.seedTextField.m_94155_();
        if (!StringUtils.isEmpty((CharSequence)s)) {
            try {
                long j = Long.parseLong(s);
                this.minimapWorld.setSlimeChunkSeed(j);
            }
            catch (NumberFormatException numberformatexception) {
                this.minimapWorld.setSlimeChunkSeed(Long.valueOf(s.hashCode()));
            }
        }
        try {
            this.session.getWorldManagerIO().saveWorld(this.minimapWorld);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }
}

