/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.integration.CreateCompat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PresentRecipientAttribute
implements ItemAttribute {
    public static final PresentRecipientAttribute EMPTY = new PresentRecipientAttribute("@e");
    String recipient;

    public PresentRecipientAttribute(String recipient) {
        this.recipient = recipient;
    }

    public boolean appliesTo(ItemStack itemStack, Level level) {
        return PresentRecipientAttribute.readRecipient(itemStack).equals(this.recipient);
    }

    public ItemAttributeType getType() {
        return CreateCompat.PRESENT_ATTRIBUTE.get();
    }

    public String getTranslationKey() {
        return "present_recipient";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{this.recipient};
    }

    public void save(CompoundTag compoundTag) {
        compoundTag.m_128359_("recipient", this.recipient);
    }

    public void load(CompoundTag compoundTag) {
        this.recipient = compoundTag.m_128461_("recipient");
    }

    private static String readRecipient(ItemStack itemStack) {
        String name;
        CompoundTag t;
        if (itemStack.m_41720_() instanceof PresentItem && (t = itemStack.m_41737_("BlockEntityTag")) != null && !(name = t.m_128461_("Recipient")).equals("@e")) {
            return name;
        }
        return "";
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new PresentRecipientAttribute("@e");
        }

        public List<ItemAttribute> getAllAttributes(ItemStack itemStack, Level level) {
            String name = PresentRecipientAttribute.readRecipient(itemStack);
            ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
            if (!name.isEmpty()) {
                atts.add(new PresentRecipientAttribute(name));
            }
            return atts;
        }
    }
}

