/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.mojang.logging.LogUtils;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.config.GeneralClientConfig;
import com.wildfire.main.networking.WildfireSync;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="wildfire_gender")
public class WildfireGender {
    public static final String VERSION = "3.0.1";
    public static final String MODID = "wildfire_gender";
    public static final Logger logger = LogUtils.getLogger();
    public static Map<UUID, GenderPlayer> CLOTHING_PLAYERS = new HashMap<UUID, GenderPlayer>();

    public WildfireGender() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(WildfireSync::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onStartTracking);
        if (FMLEnvironment.dist.isClient()) {
            GeneralClientConfig.register(ModLoadingContext.get().getActiveContainer());
        }
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    @Nullable
    public static GenderPlayer getPlayerById(UUID id) {
        return CLOTHING_PLAYERS.get(id);
    }

    public static GenderPlayer getOrAddPlayerById(UUID id) {
        return CLOTHING_PLAYERS.computeIfAbsent(id, GenderPlayer::new);
    }

    private void onStartTracking(PlayerEvent.StartTracking evt) {
        Entity entity = evt.getTarget();
        if (entity instanceof Player) {
            Player toSync = (Player)entity;
            entity = evt.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer sendTo = (ServerPlayer)entity;
                GenderPlayer genderToSync = WildfireGender.getPlayerById(toSync.m_20148_());
                if (genderToSync == null) {
                    return;
                }
                WildfireSync.sendToClient(sendTo, genderToSync);
            }
        }
    }

    public static void loadGenderInfoAsync(UUID uuid, boolean markForSync) {
        Thread thread = new Thread(() -> WildfireGender.loadGenderInfo(uuid, markForSync));
        thread.setName("WFGM_GetPlayer-" + uuid);
        thread.start();
    }

    public static GenderPlayer loadGenderInfo(UUID uuid, boolean markForSync) {
        return GenderPlayer.loadCachedPlayer(uuid, markForSync);
    }
}

