/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.slab;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.foundation.copycat.CopycatTransformableState;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.foundation.copycat.multistate.WaterloggedMultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockFaceUtils;
import com.copycatsplus.copycats.utility.InteractionUtils;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatSlabBlock
extends WaterloggedMultiStateCopycatBlock
implements SpecialBlockItemRequirement {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<SlabType> SLAB_TYPE = BlockStateProperties.f_61397_;
    private final ImmutableMap<FaceData, VoxelShape> partialFaceCache;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public CopycatSlabBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String property : this.storageProperties()) {
            for (Direction.Axis axis : AXIS.m_6908_()) {
                for (Direction face : Direction.values()) {
                    builder.put((Object)new FaceData(property, axis, face), (Object)BlockFaceUtils.getPartialFaceShape(null, (BlockState)((BlockState)this.m_49966_().m_61124_(SLAB_TYPE, (Comparable)SlabType.DOUBLE)).m_61124_(AXIS, (Comparable)axis), property, face));
                }
            }
        }
        this.partialFaceCache = builder.build();
    }

    @Override
    public String defaultProperty() {
        return SlabType.TOP.m_7912_();
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3i(2, 1, 1);
            case Direction.Axis.Y -> new Vec3i(1, 2, 1);
            case Direction.Axis.Z -> new Vec3i(1, 1, 2);
        };
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        if (hitLocation.m_123304_((Direction.Axis)state.m_61143_(AXIS)) > 0) {
            return SlabType.TOP.m_7912_();
        }
        return SlabType.BOTTOM.m_7912_();
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (property.equals(SlabType.TOP.m_7912_())) {
                    yield new Vec3i(1, 0, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Y -> {
                if (property.equals(SlabType.TOP.m_7912_())) {
                    yield new Vec3i(0, 1, 0);
                }
                yield new Vec3i(0, 0, 0);
            }
            case Direction.Axis.Z -> property.equals(SlabType.TOP.m_7912_()) ? new Vec3i(0, 0, 1) : new Vec3i(0, 0, 0);
        };
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        SlabType slabType = (SlabType)state.m_61143_(SLAB_TYPE);
        if (property.equals(SlabType.BOTTOM.m_7912_())) {
            return slabType == SlabType.DOUBLE || slabType == SlabType.BOTTOM;
        }
        if (property.equals(SlabType.TOP.m_7912_())) {
            return slabType == SlabType.DOUBLE || slabType == SlabType.TOP;
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(SlabType.TOP.m_7912_(), SlabType.BOTTOM.m_7912_());
    }

    @Override
    public int getColorIndex(String property) {
        return property.equals(SlabType.BOTTOM.m_7912_()) ? 0 : 1;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        return InteractionUtils.sequential(() -> InteractionUtils.usePlacementHelper(placementHelperId, state, world, pos, player, hand, ray), () -> super.m_6227_(state, world, pos, player, hand, ray));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        if (state.m_61143_(SLAB_TYPE) != SlabType.DOUBLE) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        String property = this.getPropertyFromInteraction(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), true);
        if (!this.partExists(state, property)) {
            return InteractionResult.FAIL;
        }
        if (world instanceof ServerLevel) {
            if (player != null) {
                List drops = Block.m_49874_((BlockState)((BlockState)this.m_49966_().m_61124_(SLAB_TYPE, (Comparable)(property.equals(SlabType.BOTTOM.m_7912_()) ? SlabType.BOTTOM : SlabType.TOP))), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                if (!player.m_7500_()) {
                    for (ItemStack drop : drops) {
                        player.m_150109_().m_150079_(drop);
                    }
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_(SLAB_TYPE, (Comparable)(property.equals(SlabType.BOTTOM.m_7912_()) ? SlabType.TOP : SlabType.BOTTOM))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        Item item = this.m_5456_();
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)item, switch ((SlabType)state.m_61143_(SLAB_TYPE)) {
            default -> throw new IncompatibleClassChangeError();
            case SlabType.BOTTOM, SlabType.TOP -> 1;
            case SlabType.DOUBLE -> 2;
        }));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            return (BlockState)((BlockState)state.m_61124_(SLAB_TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        Direction.Axis axis = context.m_7820_().m_122434_();
        boolean flag = switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (context.m_43720_().f_82479_ - (double)blockPos.m_123341_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (context.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> context.m_43720_().f_82481_ - (double)blockPos.m_123343_() > 0.5;
        };
        Direction clickedFace = context.m_43719_();
        return (BlockState)((BlockState)stateForPlacement.m_61124_(AXIS, (Comparable)axis)).m_61124_(SLAB_TYPE, (Comparable)(clickedFace == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || clickedFace.m_122434_() != axis && !flag ? SlabType.BOTTOM : SlabType.TOP));
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        SlabType slabtype = (SlabType)pState.m_61143_(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (slabtype != SlabType.DOUBLE && itemstack.m_150930_(this.m_5456_())) {
            boolean flag = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    if (pUseContext.m_43720_().f_82479_ - (double)pUseContext.m_8083_().m_123341_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (pUseContext.m_43720_().f_82480_ - (double)pUseContext.m_8083_().m_123342_() > 0.5) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> pUseContext.m_43720_().f_82481_ - (double)pUseContext.m_8083_().m_123343_() > 0.5;
            };
            Direction direction = pUseContext.m_43719_();
            if (slabtype == SlabType.BOTTOM) {
                return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) || flag;
            }
            return direction == Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE) || !flag;
        }
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{AXIS}).m_61104_(new Property[]{SLAB_TYPE}));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return super.m_7357_(pState, pLevel, pPos, pType);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        SlabType type = (SlabType)pState.m_61143_(SLAB_TYPE);
        Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
        if (type == SlabType.DOUBLE) {
            return Shapes.m_83144_();
        }
        if (type == SlabType.BOTTOM) {
            return CCShapes.SLAB_BOTTOM.get(axis).toShape();
        }
        return CCShapes.SLAB_TOP.get(axis).toShape();
    }

    @Override
    public VoxelShape getPartialFaceShape(BlockGetter level, BlockState state, String property, Direction face) {
        if (!this.partExists(state, property)) {
            return Shapes.m_83040_();
        }
        return Objects.requireNonNull((VoxelShape)this.partialFaceCache.getOrDefault((Object)new FaceData(property, (Direction.Axis)state.m_61143_(AXIS), face), (Object)Shapes.m_83040_()));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    public static CopycatTransformableState<Void> toTransformableState(BlockState state) {
        return CopycatTransformableState.create(t -> {
            Direction facing = CopycatSlabBlock.getApparentDirection(state);
            Vec3i normal = facing.m_122436_();
            Vec3i part = new Vec3i(normal.m_123341_() == 0 ? 8 : (normal.m_123341_() > 0 ? 16 : 0), normal.m_123342_() == 0 ? 8 : (normal.m_123342_() > 0 ? 16 : 0), normal.m_123343_() == 0 ? 8 : (normal.m_123343_() > 0 ? 16 : 0));
            t.addPart(part.m_123341_(), part.m_123342_(), part.m_123343_());
            if (state.m_61143_(SLAB_TYPE) == SlabType.DOUBLE) {
                Vec3i part2 = new Vec3i(16, 16, 16).m_121996_(part);
                t.addPart(part2.m_123341_(), part2.m_123342_(), part2.m_123343_());
            }
        });
    }

    public static CopycatTransformableState<MaterialItemStorage.MaterialItem> toTransformableStorage(BlockState state, IMultiStateCopycatBlockEntity be) {
        return CopycatTransformableState.create(t -> {
            Direction facing = CopycatSlabBlock.getApparentDirection(state);
            Vec3i normal = facing.m_122436_();
            Vec3i part = new Vec3i(normal.m_123341_() == 0 ? 8 : (normal.m_123341_() > 0 ? 16 : 0), normal.m_123342_() == 0 ? 8 : (normal.m_123342_() > 0 ? 16 : 0), normal.m_123343_() == 0 ? 8 : (normal.m_123343_() > 0 ? 16 : 0));
            t.addPart(part.m_123341_(), part.m_123342_(), part.m_123343_()).setData(be.getMaterialItemStorage().getMaterialItem(facing.m_122421_() == Direction.AxisDirection.POSITIVE ? Half.TOP.m_7912_() : Half.BOTTOM.m_7912_()));
            if (state.m_61143_(SLAB_TYPE) == SlabType.DOUBLE) {
                Vec3i part2 = new Vec3i(16, 16, 16).m_121996_(part);
                t.addPart(part2.m_123341_(), part2.m_123342_(), part2.m_123343_()).setData(be.getMaterialItemStorage().getMaterialItem(facing.m_122421_() == Direction.AxisDirection.POSITIVE ? Half.BOTTOM.m_7912_() : Half.TOP.m_7912_()));
            }
        });
    }

    public static BlockState fromTransformableState(BlockState state, CopycatTransformableState<Void> transformableState) {
        SlabType type;
        Direction.Axis axis;
        CopycatTransformableState.Part part = transformableState.parts.get(0);
        if (part.vector.m_123341_() != 8) {
            axis = Direction.Axis.X;
            type = part.vector.m_123341_() > 8 ? SlabType.TOP : SlabType.BOTTOM;
        } else if (part.vector.m_123342_() != 8) {
            axis = Direction.Axis.Y;
            type = part.vector.m_123342_() > 8 ? SlabType.TOP : SlabType.BOTTOM;
        } else {
            axis = Direction.Axis.Z;
            SlabType slabType = type = part.vector.m_123343_() > 8 ? SlabType.TOP : SlabType.BOTTOM;
        }
        if (transformableState.parts.size() == 2) {
            type = SlabType.DOUBLE;
        }
        return (BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)axis)).m_61124_(SLAB_TYPE, (Comparable)type);
    }

    public static void fromTransformableStorage(BlockState state, IMultiStateCopycatBlockEntity be, CopycatTransformableState<MaterialItemStorage.MaterialItem> transformableState) {
        for (String string : be.getMaterialItemStorage().getAllProperties()) {
            be.getMaterialItemStorage().storeMaterialItem(string, new MaterialItemStorage.MaterialItem(AllBlocks.COPYCAT_BASE.getDefaultState(), ItemStack.f_41583_));
        }
        for (CopycatTransformableState.Part part : transformableState.parts) {
            be.getMaterialItemStorage().storeMaterialItem(part.vector.m_123341_() > 8 || part.vector.m_123342_() > 8 || part.vector.m_123343_() > 8 ? Half.TOP.m_7912_() : Half.BOTTOM.m_7912_(), (MaterialItemStorage.MaterialItem)part.data);
        }
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return CopycatSlabBlock.fromTransformableState(state, CopycatSlabBlock.toTransformableState(state).transform(transform));
    }

    @Override
    public void transformStorage(BlockState state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
        state = CopycatSlabBlock.fromTransformableState(state, CopycatSlabBlock.toTransformableState(state).untransform(transform));
        CopycatSlabBlock.fromTransformableStorage(state, be, CopycatSlabBlock.toTransformableStorage(state, be).transform(transform));
    }

    public static FaceShape getFaceShape(BlockState state, Direction face) {
        SlabType slab = (SlabType)state.m_61143_(SLAB_TYPE);
        if (state.m_61143_(AXIS) != face.m_122434_()) {
            return FaceShape.forSlabSide(slab);
        }
        return switch (slab) {
            default -> throw new IncompatibleClassChangeError();
            case SlabType.TOP -> FaceShape.fullOrNone(face.m_122421_() == Direction.AxisDirection.POSITIVE);
            case SlabType.BOTTOM -> FaceShape.fullOrNone(face.m_122421_() == Direction.AxisDirection.NEGATIVE);
            case SlabType.DOUBLE -> FaceShape.FULL;
        };
    }

    public static Direction getApparentDirection(BlockState state) {
        return Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), (Direction.AxisDirection)(state.m_61143_(SLAB_TYPE) == SlabType.BOTTOM ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
    }

    public static BlockState setApparentDirection(BlockState state, Direction direction) {
        SlabType type = (SlabType)state.m_61143_(SLAB_TYPE);
        if (type == SlabType.DOUBLE) {
            return (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_());
        }
        if (CopycatSlabBlock.getApparentDirection(state).m_122421_() != direction.m_122421_()) {
            return (BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_())).m_61124_(SLAB_TYPE, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
        }
        return (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_());
    }

    private record FaceData(String property, Direction.Axis axis, Direction face) {
    }

    public static enum FaceShape {
        FULL,
        TOP,
        BOTTOM,
        NONE;


        public static FaceShape forSlabSide(SlabType type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SlabType.TOP -> TOP;
                case SlabType.BOTTOM -> BOTTOM;
                case SlabType.DOUBLE -> FULL;
            };
        }

        public static FaceShape fullOrNone(boolean value) {
            return value ? FULL : NONE;
        }

        public static boolean canConnect(FaceShape shape1, FaceShape shape2) {
            return shape1 == shape2 || shape1 == FULL && shape2 != NONE || shape2 == FULL && shape1 != NONE;
        }

        public boolean hasContact() {
            return this != NONE;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CCBlocks.COPYCAT_SLAB.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            if (((SlabType)state.m_61143_(SLAB_TYPE)).equals((Object)SlabType.DOUBLE)) {
                return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)))).m_61124_(SLAB_TYPE, (Comparable)SlabType.BOTTOM));
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)))).m_61124_(SLAB_TYPE, (Comparable)((SlabType)state.m_61143_(SLAB_TYPE))));
        }
    }
}

