/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI.navigation;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class HamsterNavigation
extends GroundPathNavigation {
    private final HamsterEntity hamster;
    @Nullable
    private BlockPos avoidanceWaypoint = null;
    @Nullable
    private BlockPos waypointTargetSnapshot = null;
    @Nullable
    private Entity waypointEntitySnapshot = null;
    @Nullable
    private BlockPos lastUnsafeTarget = null;
    private int unsafeCycles = 0;
    private static final int MAX_ALT_ATTEMPTS = 10;
    private static final int ALT_RADIUS = 4;
    private static final double WAYPOINT_REACH_DIST_SQ = 2.25;
    private static final double TARGET_MOVE_REPATH_DIST_SQ = 25.0;
    private static final int ALLOW_UNSAFE_AFTER_CYCLES = 6;

    public HamsterNavigation(HamsterEntity hamster, Level world) {
        super((Mob)hamster, world);
        this.hamster = hamster;
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] HamsterNavigation constructed for hamster {}", (Object)hamster.m_20148_());
    }

    public boolean m_26519_(double x, double y, double z, double speed) {
        Path planned;
        BlockPos target = BlockPos.m_274561_((double)x, (double)y, (double)z);
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] startMovingTo(xyz={}, speed={})  waypoint={}", new Object[]{target, speed, this.avoidanceWaypoint});
        if (this.isWaypointValidForTarget(target, null)) {
            Path wp = super.m_7864_(this.avoidanceWaypoint, 0);
            if (wp != null) {
                AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Using existing waypoint {} toward {}", (Object)this.avoidanceWaypoint, (Object)target);
                return this.m_26536_(wp, speed);
            }
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Waypoint {} no longer pathable; clearing", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
        }
        return (planned = this.planPathWithWaypoint(target, null)) != null && this.m_26536_(planned, speed);
    }

    public boolean m_5624_(Entity entity, double speed) {
        Path planned;
        BlockPos target = entity.m_20183_();
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] startMovingTo(entity={}, speed={}) waypoint={}", new Object[]{entity.m_7755_().getString(), speed, this.avoidanceWaypoint});
        if (this.isWaypointValidForTarget(target, entity)) {
            Path wp = super.m_7864_(this.avoidanceWaypoint, 0);
            if (wp != null) {
                AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Using existing waypoint {} toward entity {}", (Object)this.avoidanceWaypoint, (Object)entity.m_7755_().getString());
                return this.m_26536_(wp, speed);
            }
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Waypoint {} no longer pathable; clearing", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
        }
        return (planned = this.planPathWithWaypoint(target, entity)) != null && this.m_26536_(planned, speed);
    }

    @Nullable
    public Path m_7864_(BlockPos pos, int range) {
        return super.m_7864_(pos, range);
    }

    public void m_7638_() {
        double d2;
        super.m_7638_();
        if (this.avoidanceWaypoint != null && (d2 = this.hamster.m_20275_((double)this.avoidanceWaypoint.m_123341_() + 0.5, (double)this.avoidanceWaypoint.m_123342_() + 0.1, (double)this.avoidanceWaypoint.m_123343_() + 0.5)) <= 2.25) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Reached waypoint {}; clearing", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
        }
    }

    @Nullable
    private Path planPathWithWaypoint(BlockPos targetPos, @Nullable Entity targetEntity) {
        boolean directUnsafe;
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] planPathWithWaypoint target={}", (Object)targetPos);
        Path direct = super.m_7864_(targetPos, 0);
        boolean bl = directUnsafe = direct != null && this.hamster.isPathThroughUnlinkedBed(direct);
        if (!directUnsafe) {
            this.hamster.pathingFailures = 0;
            this.hamster.lastFailedTarget = null;
            if (this.avoidanceWaypoint != null) {
                AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Direct path safe; clearing previous waypoint {}", (Object)this.avoidanceWaypoint);
                this.clearWaypoint();
            }
            return direct;
        }
        if (this.hamster.lastFailedTarget == null || !this.hamster.lastFailedTarget.equals((Object)targetPos)) {
            this.hamster.pathingFailures = 1;
            this.hamster.lastFailedTarget = targetPos.m_7949_();
        } else {
            ++this.hamster.pathingFailures;
        }
        if (this.hamster.pathingFailures >= 6) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] No safe alternates after {} cycles; allowing direct unsafe path to {}", (Object)this.hamster.pathingFailures, (Object)targetPos);
            this.hamster.pathingFailures = 0;
            this.hamster.lastFailedTarget = null;
            this.clearWaypoint();
            return direct;
        }
        for (int i = 0; i < 10; ++i) {
            int dz;
            int dx = this.hamster.m_217043_().m_216332_(-4, 4);
            BlockPos alt = targetPos.m_7918_(dx, 0, dz = this.hamster.m_217043_().m_216332_(-4, 4));
            Path altPath = super.m_7864_(alt, 0);
            boolean altUnsafe = altPath == null || this.hamster.isPathThroughUnlinkedBed(altPath);
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Alt attempt {}: {} \u2192 {} unsafe={}", new Object[]{i + 1, alt, altPath == null ? "null" : "len=" + altPath.m_77398_(), altUnsafe});
            if (altUnsafe) continue;
            this.setWaypoint(alt, targetPos, targetEntity);
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Using safe waypoint {} toward {}", (Object)this.avoidanceWaypoint, (Object)targetPos);
            return altPath;
        }
        AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] No safe alternates this cycle; will retry next tick; refusing unsafe path to {}", (Object)targetPos);
        return null;
    }

    private boolean isWaypointValidForTarget(BlockPos currentTargetPos, @Nullable Entity currentEntityTarget) {
        double movedSq;
        if (this.avoidanceWaypoint == null) {
            return false;
        }
        if (this.waypointEntitySnapshot != null && currentEntityTarget != null && (movedSq = currentEntityTarget.m_20275_(this.waypointEntitySnapshot.m_20185_(), this.waypointEntitySnapshot.m_20186_(), this.waypointEntitySnapshot.m_20189_())) > 25.0) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Target entity moved too far; invalidating waypoint {}", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
            return false;
        }
        if (this.waypointTargetSnapshot != null && this.waypointTargetSnapshot.m_123331_((Vec3i)currentTargetPos) > 25.0) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Target position moved {}; invalidating waypoint {}", (Object)this.waypointTargetSnapshot, (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
            return false;
        }
        Path directNow = super.m_7864_(currentTargetPos, 0);
        if (directNow != null && !this.hamster.isPathThroughUnlinkedBed(directNow)) {
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Direct path became safe; clearing waypoint {}", (Object)this.avoidanceWaypoint);
            this.clearWaypoint();
            return false;
        }
        return true;
    }

    private void setWaypoint(BlockPos waypoint, BlockPos targetSnapshot, @Nullable Entity entitySnapshot) {
        this.avoidanceWaypoint = waypoint;
        this.waypointTargetSnapshot = targetSnapshot.m_7949_();
        this.waypointEntitySnapshot = entitySnapshot;
    }

    private void clearWaypoint() {
        this.avoidanceWaypoint = null;
        this.waypointTargetSnapshot = null;
        this.waypointEntitySnapshot = null;
    }
}

