/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.vorbis;

import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.vorbis.VorbisAudioData;
import vminus.shadow.org.gagravarr.vorbis.VorbisComments;
import vminus.shadow.org.gagravarr.vorbis.VorbisInfo;
import vminus.shadow.org.gagravarr.vorbis.VorbisPacket;
import vminus.shadow.org.gagravarr.vorbis.VorbisSetup;

public class VorbisPacketFactory {
    protected static void populateMetadataHeader(byte[] b, int type, int dataLength) {
        b[0] = IOUtils.fromInt(type);
        b[1] = 118;
        b[2] = 111;
        b[3] = 114;
        b[4] = 98;
        b[5] = 105;
        b[6] = 115;
    }

    public static boolean isVorbisStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return VorbisPacketFactory.isVorbisSpecial(firstPacket);
    }

    protected static boolean isVorbisSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 16) {
            return false;
        }
        byte type = d[0];
        return (type == 1 || type == 3 || type == 5) && d[1] == 118 && d[2] == 111 && d[3] == 114 && d[4] == 98 && d[5] == 105 && d[6] == 115;
    }

    public static VorbisPacket create(OggPacket packet) {
        if (VorbisPacketFactory.isVorbisSpecial(packet)) {
            byte type = packet.getData()[0];
            switch (type) {
                case 1: {
                    return new VorbisInfo(packet);
                }
                case 3: {
                    return new VorbisComments(packet);
                }
                case 5: {
                    return new VorbisSetup(packet);
                }
            }
        }
        return new VorbisAudioData(packet);
    }
}

