/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.opus;

import vminus.shadow.org.gagravarr.ogg.HighLevelOggStreamPacket;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.opus.OpusAudioData;
import vminus.shadow.org.gagravarr.opus.OpusInfo;
import vminus.shadow.org.gagravarr.opus.OpusPacket;
import vminus.shadow.org.gagravarr.opus.OpusTags;

public class OpusPacketFactory
extends HighLevelOggStreamPacket {
    public static boolean isOpusStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return OpusPacketFactory.isOpusSpecial(firstPacket);
    }

    protected static boolean isOpusSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 12) {
            return false;
        }
        if (IOUtils.byteRangeMatches(OpusPacket.MAGIC_HEADER_BYTES, d, 0)) {
            return true;
        }
        return IOUtils.byteRangeMatches(OpusPacket.MAGIC_TAGS_BYTES, d, 0);
    }

    public static OpusPacket create(OggPacket packet) {
        if (OpusPacketFactory.isOpusSpecial(packet)) {
            byte type = packet.getData()[4];
            switch (type) {
                case 72: {
                    return new OpusInfo(packet);
                }
                case 84: {
                    return new OpusTags(packet);
                }
            }
        }
        return new OpusAudioData(packet);
    }
}

