/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.ogg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import vminus.shadow.org.gagravarr.ogg.CRCUtils;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.ogg.OggPacketData;

public class OggPage {
    private int sid;
    private int seqNum;
    private long checksum;
    private long granulePosition;
    private boolean isBOS;
    private boolean isEOS;
    private boolean isContinue;
    private int numLVs = 0;
    private byte[] lvs = new byte[255];
    private byte[] data;
    private ByteArrayOutputStream tmpData;
    private static final int MINIMUM_PAGE_SIZE = 27;

    protected OggPage(int sid, int seqNum) {
        this.sid = sid;
        this.seqNum = seqNum;
        this.tmpData = new ByteArrayOutputStream();
    }

    protected OggPage(InputStream inp) throws IOException {
        int version = IOUtils.readOrEOF(inp);
        if (version != 0) {
            throw new IllegalArgumentException("Found Ogg page in format " + version + " but we only support version 0");
        }
        int flags = IOUtils.readOrEOF(inp);
        if ((flags & 1) == 1) {
            this.isContinue = true;
        }
        if ((flags & 2) == 2) {
            this.isBOS = true;
        }
        if ((flags & 4) == 4) {
            this.isEOS = true;
        }
        this.granulePosition = IOUtils.getInt(IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp));
        this.sid = (int)IOUtils.getInt(IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp));
        this.seqNum = (int)IOUtils.getInt(IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp));
        this.checksum = IOUtils.getInt(IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp), IOUtils.readOrEOF(inp));
        this.numLVs = IOUtils.readOrEOF(inp);
        this.lvs = new byte[this.numLVs];
        IOUtils.readFully(inp, this.lvs);
        this.data = new byte[this.getDataSize()];
        IOUtils.readFully(inp, this.data);
    }

    protected int addPacket(OggPacket packet, int offset) {
        if (packet.isBeginningOfStream()) {
            this.isBOS = true;
        }
        if (packet.isEndOfStream()) {
            this.isEOS = true;
        }
        int size = packet.getData().length;
        for (int i = this.numLVs; i < 255; ++i) {
            int remains = size - offset;
            int toAdd = 255;
            if (remains < 255) {
                toAdd = remains;
            }
            this.lvs[i] = IOUtils.fromInt(toAdd);
            this.tmpData.write(packet.getData(), offset, toAdd);
            ++this.numLVs;
            offset += toAdd;
            if (toAdd < 255) break;
        }
        return offset;
    }

    public boolean isChecksumValid() {
        if (this.checksum == 0L) {
            return true;
        }
        int crc = CRCUtils.getCRC(this.getHeader());
        if (this.data != null && this.data.length > 0) {
            crc = CRCUtils.getCRC(this.data, crc);
        }
        return this.checksum == (long)crc;
    }

    protected long getChecksum() {
        return this.checksum;
    }

    protected boolean hasSpaceFor(int bytes) {
        int reqLVs = (int)Math.ceil((double)bytes / 255.0);
        return this.numLVs + reqLVs <= 255;
    }

    public static int getMinimumPageSize() {
        return 27;
    }

    public int getPageSize() {
        int size = 27 + this.numLVs;
        return size += this.getDataSize();
    }

    public int getDataSize() {
        int size = 0;
        for (int i = 0; i < this.numLVs; ++i) {
            size += IOUtils.toInt(this.lvs[i]);
        }
        return size;
    }

    public int getSid() {
        return this.sid;
    }

    public int getSequenceNumber() {
        return this.seqNum;
    }

    public long getGranulePosition() {
        return this.granulePosition;
    }

    public byte[] getData() {
        if (this.tmpData != null && (this.data == null || this.tmpData.size() != this.data.length)) {
            this.data = this.tmpData.toByteArray();
        }
        return this.data;
    }

    protected void setGranulePosition(long position) {
        this.granulePosition = position;
    }

    public boolean hasContinuation() {
        if (this.numLVs == 0) {
            return false;
        }
        return IOUtils.toInt(this.lvs[this.numLVs - 1]) == 255;
    }

    public boolean isContinuation() {
        return this.isContinue;
    }

    protected void setIsContinuation() {
        this.isContinue = true;
    }

    protected void setIsEOS() {
        this.isEOS = true;
    }

    protected int getNumLVs() {
        return this.numLVs;
    }

    public void writeHeader(OutputStream out) throws IOException {
        byte[] header = this.getHeader();
        this.getData();
        int crc = CRCUtils.getCRC(header);
        if (this.data != null && this.data.length > 0) {
            crc = CRCUtils.getCRC(this.data, crc);
        }
        IOUtils.putInt4(header, 22, crc);
        this.checksum = crc;
        out.write(header);
    }

    protected byte[] getHeader() {
        byte[] header = new byte[27 + this.numLVs];
        header[0] = 79;
        header[1] = 103;
        header[2] = 103;
        header[3] = 83;
        header[4] = 0;
        int flags = 0;
        if (this.isContinue) {
            flags = (byte)(flags + 1);
        }
        if (this.isBOS) {
            flags = (byte)(flags + 2);
        }
        if (this.isEOS) {
            flags = (byte)(flags + 4);
        }
        header[5] = flags;
        IOUtils.putInt8(header, 6, this.granulePosition);
        IOUtils.putInt4(header, 14, this.sid);
        IOUtils.putInt4(header, 18, this.seqNum);
        header[26] = IOUtils.fromInt(this.numLVs);
        System.arraycopy(this.lvs, 0, header, 27, this.numLVs);
        return header;
    }

    public String toString() {
        return "Ogg Page - " + this.getSid() + " @ " + this.getSequenceNumber() + " - " + this.numLVs + " LVs";
    }

    public OggPacketIterator getPacketIterator() {
        return new OggPacketIterator(null);
    }

    public OggPacketIterator getPacketIterator(OggPacketData previousPart) {
        return new OggPacketIterator(previousPart);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OggPacketIterator
    implements Iterator<OggPacketData> {
        private OggPacketData prevPart;
        private int currentLV = 0;
        private int currentOffset = 0;

        private OggPacketIterator(OggPacketData previousPart) {
            this.prevPart = previousPart;
        }

        @Override
        public boolean hasNext() {
            if (this.currentLV < OggPage.this.numLVs) {
                return true;
            }
            return this.currentLV == 0 && OggPage.this.numLVs == 0;
        }

        @Override
        public OggPacketData next() {
            OggPacketData packet;
            boolean continues = false;
            int packetLVs = 0;
            int packetSize = 0;
            for (int i = this.currentLV; i < OggPage.this.numLVs; ++i) {
                int size = IOUtils.toInt(OggPage.this.lvs[i]);
                packetSize += size;
                ++packetLVs;
                if (size < 255) break;
                if (i != OggPage.this.numLVs - 1 || size != 255) continue;
                continues = true;
            }
            byte[] pd = new byte[packetSize];
            for (int i = this.currentLV; i < this.currentLV + packetLVs; ++i) {
                int size = IOUtils.toInt(OggPage.this.lvs[i]);
                int offset = (i - this.currentLV) * 255;
                System.arraycopy(OggPage.this.data, this.currentOffset + offset, pd, offset, size);
            }
            if (this.prevPart != null) {
                int prevSize = this.prevPart.getData().length;
                byte[] fpd = new byte[prevSize + pd.length];
                System.arraycopy(this.prevPart.getData(), 0, fpd, 0, prevSize);
                System.arraycopy(pd, 0, fpd, prevSize, pd.length);
                this.prevPart = null;
                pd = fpd;
            }
            if (continues) {
                packet = new OggPacketData(pd);
            } else {
                boolean packetBOS = false;
                boolean packetEOS = false;
                if (OggPage.this.isBOS && this.currentLV == 0) {
                    packetBOS = true;
                }
                if (OggPage.this.isEOS && this.currentLV + packetLVs == OggPage.this.numLVs) {
                    packetEOS = true;
                }
                packet = new OggPacket(OggPage.this, pd, packetBOS, packetEOS);
            }
            this.currentLV += packetLVs;
            this.currentOffset += packetSize;
            if (this.currentLV == 0) {
                this.currentLV = 1;
            }
            return packet;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Remove not supported");
        }
    }
}

