/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.ogg;

import java.io.IOException;
import java.io.InputStream;

public class BitsReader {
    private InputStream input;
    private int tmp = 0;
    private int remaining = 0;
    private boolean eof = false;

    public BitsReader(InputStream input) {
        this.input = input;
    }

    public int read(int numBits) throws IOException {
        int res = 0;
        while (numBits > 0 && !this.eof) {
            if (this.remaining == 0) {
                this.tmp = this.input.read();
                if (this.tmp == -1) {
                    this.eof = true;
                    return -1;
                }
                this.remaining = 8;
            }
            int toNibble = Math.min(this.remaining, numBits);
            int toLeave = this.remaining - toNibble;
            int leaveMask = (1 << toLeave) - 1;
            res <<= toNibble;
            res += this.tmp >> toLeave;
            this.tmp &= leaveMask;
            this.remaining -= toNibble;
            numBits -= toNibble;
        }
        if (this.eof) {
            return -1;
        }
        return res;
    }

    public int bitsToNextZero() throws IOException {
        int count = 0;
        while (this.read(1) == 1) {
            ++count;
        }
        return count;
    }

    public int bitsToNextOne() throws IOException {
        int count = 0;
        while (this.read(1) == 0) {
            ++count;
        }
        return count;
    }

    public int readToByteBoundary() throws IOException {
        if (this.remaining == 0) {
            return -1;
        }
        return this.read(this.remaining);
    }

    public boolean isEOF() {
        return this.eof;
    }
}

