/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.flac;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import vminus.shadow.org.gagravarr.flac.FlacAudioSubFrame;
import vminus.shadow.org.gagravarr.flac.FlacFrame;
import vminus.shadow.org.gagravarr.flac.FlacInfo;
import vminus.shadow.org.gagravarr.ogg.BitsReader;
import vminus.shadow.org.gagravarr.ogg.BytesCapturingInputStream;
import vminus.shadow.org.gagravarr.ogg.IOUtils;

public class FlacAudioFrame
extends FlacFrame {
    private boolean blockSizeVariable;
    private long codedNumber;
    private int blockSizeRaw;
    private int blockSize;
    private int sampleRateRaw;
    private int sampleRate;
    private int numChannels;
    private int channelType;
    private int sampleSizeRaw;
    private int sampleSizeBits;
    private FlacAudioSubFrame[] subFrames;
    private byte[] frameData;
    private static final int FRAME_SYNC = 16382;
    private static final SampleRate[] RATES = new SampleRate[]{new SampleRate(0.0), new SampleRate(88.2), new SampleRate(176.4), new SampleRate(192.0), new SampleRate(8.0), new SampleRate(16.0), new SampleRate(22.05), new SampleRate(24.0), new SampleRate(32.0), new SampleRate(44.1), new SampleRate(48.0), new SampleRate(96.0)};
    protected static final int CHANNEL_TYPE_LEFT = 9;
    protected static final int CHANNEL_TYPE_RIGHT = 10;
    protected static final int CHANNEL_TYPE_MID = 11;

    public FlacAudioFrame(byte[] data, FlacInfo info) throws IOException {
        this(new ByteArrayInputStream(data), info);
    }

    public FlacAudioFrame(InputStream stream, FlacInfo info) throws IOException {
        this(FlacAudioFrame.getAndCheckFirstTwo(stream), stream, info);
    }

    public FlacAudioFrame(int byte1, int byte2, InputStream stream, FlacInfo info) throws IOException {
        this(FlacAudioFrame.getAndCheckFirstTwo(byte1, byte2), stream, info);
    }

    public FlacAudioFrame(int first2, InputStream rawStream, FlacInfo info) throws IOException {
        BytesCapturingInputStream stream = new BytesCapturingInputStream(rawStream);
        this.blockSizeVariable = (first2 & 1) == 1;
        BitsReader br = new BitsReader(stream);
        this.blockSizeRaw = br.read(4);
        this.sampleRate = br.read(4);
        boolean readBlockSize8 = false;
        boolean readBlockSize16 = false;
        if (this.blockSizeRaw == 0) {
            this.blockSize = 0;
        } else if (this.blockSizeRaw == 1) {
            this.blockSize = 192;
        } else if (this.blockSizeRaw >= 2 && this.blockSizeRaw < 5) {
            this.blockSize = 576 * (int)Math.pow(2.0, this.blockSizeRaw - 2);
        } else if (this.blockSizeRaw == 6) {
            readBlockSize8 = true;
        } else if (this.blockSizeRaw == 7) {
            readBlockSize16 = true;
        } else {
            this.blockSize = 256 * (int)Math.pow(2.0, this.blockSizeRaw - 8);
        }
        if (this.sampleRateRaw == 0) {
            this.sampleRate = info.getSampleRate();
        } else if (this.sampleRateRaw < RATES.length) {
            this.sampleRate = FlacAudioFrame.RATES[this.sampleRateRaw].Hz;
        }
        this.channelType = br.read(4);
        this.numChannels = this.channelType < 8 ? this.channelType + 1 : 2;
        this.sampleSizeRaw = br.read(3);
        br.read(1);
        if (this.sampleSizeRaw == 0) {
            this.sampleSizeBits = info.getBitsPerSample();
        } else if (this.sampleSizeRaw == 1) {
            this.sampleSizeBits = 8;
        } else if (this.sampleSizeRaw == 2) {
            this.sampleSizeBits = 12;
        } else if (this.sampleSizeRaw == 3) {
            this.sampleSizeBits = 0;
        } else if (this.sampleSizeRaw == 4) {
            this.sampleSizeBits = 16;
        } else if (this.sampleSizeRaw == 5) {
            this.sampleSizeBits = 20;
        } else if (this.sampleSizeRaw == 6) {
            this.sampleSizeBits = 24;
        } else if (this.sampleSizeRaw == 7) {
            this.sampleSizeBits = 0;
        }
        this.codedNumber = IOUtils.readUE7(stream);
        if (readBlockSize8) {
            this.blockSize = stream.read() + 1;
        }
        if (readBlockSize16) {
            this.blockSize = IOUtils.getIntBE(stream.read(), stream.read()) + 1;
        }
        if (this.sampleRateRaw == 12) {
            this.sampleRate = stream.read();
        }
        if (this.sampleRateRaw == 13) {
            this.sampleRate = IOUtils.getIntBE(stream.read(), stream.read());
        }
        if (this.sampleRateRaw == 14) {
            this.sampleRate = 10 * IOUtils.getIntBE(stream.read(), stream.read());
        }
        stream.read();
        this.subFrames = new FlacAudioSubFrame[this.numChannels];
        for (int cn = 0; cn < this.numChannels; ++cn) {
            br.read(1);
            int type = br.read(6);
            int wb = br.read(1);
            if (wb == 1) {
                wb = br.bitsToNextOne() + 1;
            }
            if (br.isEOF()) {
                throw new IllegalArgumentException("No data left to read subframe for channel " + (cn + 1) + " of " + this.numChannels);
            }
            this.subFrames[cn] = FlacAudioSubFrame.create(type, cn, wb, this, br);
        }
        br.readToByteBoundary();
        stream.read();
        stream.read();
        this.frameData = stream.getData();
    }

    private static int getAndCheckFirstTwo(InputStream stream) throws IOException {
        int byte1 = stream.read();
        int byte2 = stream.read();
        return FlacAudioFrame.getAndCheckFirstTwo(byte1, byte2);
    }

    private static int getAndCheckFirstTwo(int byte1, int byte2) throws IOException {
        int first2 = IOUtils.getIntBE(byte1, byte2);
        if (!FlacAudioFrame.isFrameHeaderStart(first2)) {
            throw new IllegalArgumentException("Frame Header start sync not found");
        }
        return first2;
    }

    public static boolean isFrameHeaderStart(int byte1, int byte2) {
        return FlacAudioFrame.isFrameHeaderStart(IOUtils.getIntBE(byte1, byte2));
    }

    public static boolean isFrameHeaderStart(int first2) {
        return first2 >> 2 == 16382;
    }

    public byte[] getData() {
        byte[] data = new byte[this.frameData.length + 2];
        int first2 = 65528;
        if (this.blockSizeVariable) {
            ++first2;
        }
        IOUtils.putInt2BE(data, 0, first2);
        System.arraycopy(this.frameData, 0, data, 2, this.frameData.length);
        return data;
    }

    public boolean isBlockSizeVariable() {
        return this.blockSizeVariable;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getBitsPerSample() {
        return this.sampleSizeBits;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    protected int getChannelType() {
        return this.channelType;
    }

    public long getCodedNumber() {
        return this.codedNumber;
    }

    public FlacAudioSubFrame[] getSubFrames() {
        return this.subFrames;
    }

    protected static class SampleRate {
        protected final double kHz;
        protected final int Hz;

        private SampleRate(double kHz) {
            this.kHz = kHz;
            this.Hz = (int)Math.rint(kHz * 1000.0);
        }
    }
}

