/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.concentus;

import vminus.shadow.org.concentus.Arrays;
import vminus.shadow.org.concentus.BoxedValueInt;
import vminus.shadow.org.concentus.CeltPitchXCorr;
import vminus.shadow.org.concentus.Inlines;

class BurgModified {
    private static final int MAX_FRAME_SIZE = 384;
    private static final int QA = 25;
    private static final int N_BITS_HEAD_ROOM = 2;
    private static final int MIN_RSHIFTS = -16;
    private static final int MAX_RSHIFTS = 7;

    BurgModified() {
    }

    static void silk_burg_modified(BoxedValueInt res_nrg, BoxedValueInt res_nrg_Q, int[] A_Q16, short[] x, int x_ptr, int minInvGain_Q30, int subfr_length, int nb_subfr, int D) {
        int nrg;
        int Atmp1;
        int k;
        int tmp1;
        int n;
        int x_offset;
        int s;
        int[] C_first_row = new int[16];
        int[] C_last_row = new int[16];
        int[] Af_QA = new int[16];
        int[] CAf = new int[17];
        int[] CAb = new int[17];
        int[] xcorr = new int[16];
        Inlines.OpusAssert(subfr_length * nb_subfr <= 384);
        long C0_64 = Inlines.silk_inner_prod16_aligned_64(x, x_ptr, x, x_ptr, subfr_length * nb_subfr);
        int lz = Inlines.silk_CLZ64(C0_64);
        int rshifts = 35 - lz;
        if (rshifts > 7) {
            rshifts = 7;
        }
        if (rshifts < -16) {
            rshifts = -16;
        }
        int C0 = rshifts > 0 ? (int)Inlines.silk_RSHIFT64(C0_64, rshifts) : Inlines.silk_LSHIFT32((int)C0_64, -rshifts);
        CAb[0] = CAf[0] = C0 + Inlines.silk_SMMUL(42950, C0) + 1;
        Arrays.MemSet(C_first_row, 0, 16);
        if (rshifts > 0) {
            for (s = 0; s < nb_subfr; ++s) {
                x_offset = x_ptr + s * subfr_length;
                for (n = 1; n < D + 1; ++n) {
                    int n2 = n - 1;
                    C_first_row[n2] = C_first_row[n2] + (int)Inlines.silk_RSHIFT64(Inlines.silk_inner_prod16_aligned_64(x, x_offset, x, x_offset + n, subfr_length - n), rshifts);
                }
            }
        } else {
            for (s = 0; s < nb_subfr; ++s) {
                x_offset = x_ptr + s * subfr_length;
                CeltPitchXCorr.pitch_xcorr(x, x_offset, x, x_offset + 1, xcorr, subfr_length - D, D);
                for (n = 1; n < D + 1; ++n) {
                    int d = 0;
                    for (int i = n + subfr_length - D; i < subfr_length; ++i) {
                        d = Inlines.MAC16_16(d, x[x_offset + i], x[x_offset + i - n]);
                    }
                    int n3 = n - 1;
                    xcorr[n3] = xcorr[n3] + d;
                }
                for (n = 1; n < D + 1; ++n) {
                    int n4 = n - 1;
                    C_first_row[n4] = C_first_row[n4] + Inlines.silk_LSHIFT32(xcorr[n - 1], -rshifts);
                }
            }
        }
        System.arraycopy(C_first_row, 0, C_last_row, 0, 16);
        CAb[0] = CAf[0] = C0 + Inlines.silk_SMMUL(42950, C0) + 1;
        int invGain_Q30 = 0x40000000;
        boolean reached_max_gain = false;
        for (n = 0; n < D; ++n) {
            int Atmp_QA;
            int tmp2;
            int x2;
            int x1;
            if (rshifts > -2) {
                for (s = 0; s < nb_subfr; ++s) {
                    x_offset = x_ptr + s * subfr_length;
                    x1 = -Inlines.silk_LSHIFT32(x[x_offset + n], 16 - rshifts);
                    x2 = -Inlines.silk_LSHIFT32(x[x_offset + subfr_length - n - 1], 16 - rshifts);
                    tmp1 = Inlines.silk_LSHIFT32(x[x_offset + n], 9);
                    tmp2 = Inlines.silk_LSHIFT32(x[x_offset + subfr_length - n - 1], 9);
                    for (k = 0; k < n; ++k) {
                        C_first_row[k] = Inlines.silk_SMLAWB(C_first_row[k], x1, x[x_offset + n - k - 1]);
                        C_last_row[k] = Inlines.silk_SMLAWB(C_last_row[k], x2, x[x_offset + subfr_length - n + k]);
                        Atmp_QA = Af_QA[k];
                        tmp1 = Inlines.silk_SMLAWB(tmp1, Atmp_QA, x[x_offset + n - k - 1]);
                        tmp2 = Inlines.silk_SMLAWB(tmp2, Atmp_QA, x[x_offset + subfr_length - n + k]);
                    }
                    tmp1 = Inlines.silk_LSHIFT32(-tmp1, 7 - rshifts);
                    tmp2 = Inlines.silk_LSHIFT32(-tmp2, 7 - rshifts);
                    for (k = 0; k <= n; ++k) {
                        CAf[k] = Inlines.silk_SMLAWB(CAf[k], tmp1, x[x_offset + n - k]);
                        CAb[k] = Inlines.silk_SMLAWB(CAb[k], tmp2, x[x_offset + subfr_length - n + k - 1]);
                    }
                }
            } else {
                for (s = 0; s < nb_subfr; ++s) {
                    x_offset = x_ptr + s * subfr_length;
                    x1 = -Inlines.silk_LSHIFT32(x[x_offset + n], -rshifts);
                    x2 = -Inlines.silk_LSHIFT32(x[x_offset + subfr_length - n - 1], -rshifts);
                    tmp1 = Inlines.silk_LSHIFT32(x[x_offset + n], 17);
                    tmp2 = Inlines.silk_LSHIFT32(x[x_offset + subfr_length - n - 1], 17);
                    for (k = 0; k < n; ++k) {
                        C_first_row[k] = Inlines.silk_MLA(C_first_row[k], x1, x[x_offset + n - k - 1]);
                        C_last_row[k] = Inlines.silk_MLA(C_last_row[k], x2, x[x_offset + subfr_length - n + k]);
                        Atmp1 = Inlines.silk_RSHIFT_ROUND(Af_QA[k], 8);
                        tmp1 = Inlines.silk_MLA(tmp1, x[x_offset + n - k - 1], Atmp1);
                        tmp2 = Inlines.silk_MLA(tmp2, x[x_offset + subfr_length - n + k], Atmp1);
                    }
                    tmp1 = -tmp1;
                    tmp2 = -tmp2;
                    for (k = 0; k <= n; ++k) {
                        CAf[k] = Inlines.silk_SMLAWW(CAf[k], tmp1, Inlines.silk_LSHIFT32(x[x_offset + n - k], -rshifts - 1));
                        CAb[k] = Inlines.silk_SMLAWW(CAb[k], tmp2, Inlines.silk_LSHIFT32(x[x_offset + subfr_length - n + k - 1], -rshifts - 1));
                    }
                }
            }
            tmp1 = C_first_row[n];
            tmp2 = C_last_row[n];
            int num = 0;
            nrg = Inlines.silk_ADD32(CAb[0], CAf[0]);
            for (k = 0; k < n; ++k) {
                Atmp_QA = Af_QA[k];
                lz = Inlines.silk_CLZ32(Inlines.silk_abs(Atmp_QA)) - 1;
                lz = Inlines.silk_min(7, lz);
                Atmp1 = Inlines.silk_LSHIFT32(Atmp_QA, lz);
                tmp1 = Inlines.silk_ADD_LSHIFT32(tmp1, Inlines.silk_SMMUL(C_last_row[n - k - 1], Atmp1), 7 - lz);
                tmp2 = Inlines.silk_ADD_LSHIFT32(tmp2, Inlines.silk_SMMUL(C_first_row[n - k - 1], Atmp1), 7 - lz);
                num = Inlines.silk_ADD_LSHIFT32(num, Inlines.silk_SMMUL(CAb[n - k], Atmp1), 7 - lz);
                nrg = Inlines.silk_ADD_LSHIFT32(nrg, Inlines.silk_SMMUL(Inlines.silk_ADD32(CAb[k + 1], CAf[k + 1]), Atmp1), 7 - lz);
            }
            CAf[n + 1] = tmp1;
            CAb[n + 1] = tmp2;
            num = Inlines.silk_ADD32(num, tmp2);
            int rc_Q31 = Inlines.silk_abs(num = Inlines.silk_LSHIFT32(-num, 1)) < nrg ? Inlines.silk_DIV32_varQ(num, nrg, 31) : (num > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
            tmp1 = 0x40000000 - Inlines.silk_SMMUL(rc_Q31, rc_Q31);
            if ((tmp1 = Inlines.silk_LSHIFT(Inlines.silk_SMMUL(invGain_Q30, tmp1), 2)) <= minInvGain_Q30) {
                tmp2 = 0x40000000 - Inlines.silk_DIV32_varQ(minInvGain_Q30, invGain_Q30, 30);
                rc_Q31 = Inlines.silk_SQRT_APPROX(tmp2);
                rc_Q31 = Inlines.silk_RSHIFT32(rc_Q31 + Inlines.silk_DIV32(tmp2, rc_Q31), 1);
                rc_Q31 = Inlines.silk_LSHIFT32(rc_Q31, 16);
                if (num < 0) {
                    rc_Q31 = -rc_Q31;
                }
                invGain_Q30 = minInvGain_Q30;
                reached_max_gain = true;
            } else {
                invGain_Q30 = tmp1;
            }
            for (k = 0; k < n + 1 >> 1; ++k) {
                tmp1 = Af_QA[k];
                tmp2 = Af_QA[n - k - 1];
                Af_QA[k] = Inlines.silk_ADD_LSHIFT32(tmp1, Inlines.silk_SMMUL(tmp2, rc_Q31), 1);
                Af_QA[n - k - 1] = Inlines.silk_ADD_LSHIFT32(tmp2, Inlines.silk_SMMUL(tmp1, rc_Q31), 1);
            }
            Af_QA[n] = Inlines.silk_RSHIFT32(rc_Q31, 6);
            if (reached_max_gain) {
                for (k = n + 1; k < D; ++k) {
                    Af_QA[k] = 0;
                }
                break;
            }
            for (k = 0; k <= n + 1; ++k) {
                tmp1 = CAf[k];
                tmp2 = CAb[n - k + 1];
                CAf[k] = Inlines.silk_ADD_LSHIFT32(tmp1, Inlines.silk_SMMUL(tmp2, rc_Q31), 1);
                CAb[n - k + 1] = Inlines.silk_ADD_LSHIFT32(tmp2, Inlines.silk_SMMUL(tmp1, rc_Q31), 1);
            }
        }
        if (reached_max_gain) {
            for (k = 0; k < D; ++k) {
                A_Q16[k] = -Inlines.silk_RSHIFT_ROUND(Af_QA[k], 9);
            }
            if (rshifts > 0) {
                for (s = 0; s < nb_subfr; ++s) {
                    x_offset = x_ptr + s * subfr_length;
                    C0 -= (int)Inlines.silk_RSHIFT64(Inlines.silk_inner_prod16_aligned_64(x, x_offset, x, x_offset, D), rshifts);
                }
            } else {
                for (s = 0; s < nb_subfr; ++s) {
                    x_offset = x_ptr + s * subfr_length;
                    C0 -= Inlines.silk_LSHIFT32(Inlines.silk_inner_prod_self(x, x_offset, D), -rshifts);
                }
            }
            res_nrg.Val = Inlines.silk_LSHIFT(Inlines.silk_SMMUL(invGain_Q30, C0), 2);
            res_nrg_Q.Val = 0 - rshifts;
        } else {
            nrg = CAf[0];
            tmp1 = 65536;
            for (k = 0; k < D; ++k) {
                Atmp1 = Inlines.silk_RSHIFT_ROUND(Af_QA[k], 9);
                nrg = Inlines.silk_SMLAWW(nrg, CAf[k + 1], Atmp1);
                tmp1 = Inlines.silk_SMLAWW(tmp1, Atmp1, Atmp1);
                A_Q16[k] = -Atmp1;
            }
            res_nrg.Val = Inlines.silk_SMLAWW(nrg, Inlines.silk_SMMUL(42950, C0), -tmp1);
            res_nrg_Q.Val = -rshifts;
        }
    }
}

