/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision.values.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.lixir.vminus.registry.VMinusRarities;
import net.lixir.vminus.vision.values.conditions.EntityStringNbtVisionCondition;
import net.lixir.vminus.vision.values.conditions.RarityVisionCondition;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.world.item.Rarity;

public abstract class AbstractVisionCondition {
    protected final boolean inverted;

    public AbstractVisionCondition(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public abstract boolean test(VisionContext var1);

    public static List<List<AbstractVisionCondition>> parseVisionConditions(JsonObject arrayObject, JsonObject jsonObject) throws JsonParseException {
        return Collections.emptyList();
    }

    @Nullable
    private static AbstractVisionCondition getAbstractVisionCondition(JsonElement conditionArrayElement) {
        JsonObject conditionObject = conditionArrayElement.getAsJsonObject();
        if (!conditionObject.has("type")) {
            throw new JsonParseException(conditionObject + " has no defined type string.");
        }
        JsonPrimitive typeElement = conditionObject.getAsJsonPrimitive("type");
        String type = typeElement.getAsString();
        AbstractVisionCondition visionCondition = null;
        boolean inverted = conditionObject.has("invert") && conditionObject.getAsJsonPrimitive("invert").getAsBoolean();
        switch (type) {
            case "rarity": {
                visionCondition = AbstractVisionCondition.parseRarityCondition(conditionObject, inverted);
                break;
            }
            case "entity_string_nbt": {
                visionCondition = AbstractVisionCondition.parseEntityStringNbtCondition(conditionObject, inverted);
            }
        }
        return visionCondition;
    }

    private static AbstractVisionCondition parseRarityCondition(JsonObject conditionObject, boolean inverted) throws JsonParseException {
        String value;
        return new RarityVisionCondition(switch (value = AbstractVisionCondition.getConditionValue(conditionObject).getAsString().toUpperCase()) {
            case "INVERTED" -> VMinusRarities.INVERTED;
            case "DELICACY" -> VMinusRarities.DELICACY;
            case "LEGENDARY" -> VMinusRarities.LEGENDARY;
            case "UNOBTAINABLE" -> VMinusRarities.UNOBTAINABLE;
            default -> Rarity.valueOf((String)value);
        }, inverted);
    }

    private static AbstractVisionCondition parseEntityStringNbtCondition(JsonObject conditionObject, boolean inverted) throws JsonParseException {
        String path = conditionObject.getAsJsonPrimitive("path").getAsString();
        String value = conditionObject.getAsJsonPrimitive("value").getAsString();
        return new EntityStringNbtVisionCondition(path, value, inverted);
    }

    private static JsonPrimitive getConditionValue(JsonObject conditionObject) throws JsonParseException {
        return AbstractVisionCondition.getConditionValue("value", conditionObject);
    }

    private static JsonPrimitive getConditionValue(String valueName, JsonObject conditionObject) throws JsonParseException {
        if (!conditionObject.has(valueName)) {
            throw new JsonParseException(conditionObject + " has no defined value string.");
        }
        return conditionObject.getAsJsonPrimitive(valueName);
    }
}

