/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionTypes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public final class VisionType<T> {
    private final String id;
    private final String multiList;
    private final Registry<? extends T> registry;
    private final Function<ResourceLocation, ?> registryGetter;
    private final BiConsumer<Object, ResourceLocation> visionSetter;
    private final Map<ResourceLocation, Vision> visions = new HashMap<ResourceLocation, Vision>();

    public VisionType(String id, String multiList, Registry<? extends T> registry, Function<ResourceLocation, ?> registryGetter, BiConsumer<Object, ResourceLocation> visionSetter) {
        this.id = id;
        this.multiList = multiList;
        this.registry = registry;
        this.registryGetter = registryGetter;
        this.visionSetter = visionSetter;
    }

    @NotNull
    public @UnmodifiableView Map<ResourceLocation, Vision> getVisions() {
        return Collections.unmodifiableMap(this.visions);
    }

    public <E> void applyVision(E target, ResourceLocation id) {
        this.visionSetter.accept(target, id);
    }

    public void resetVisionTypes() {
        for (Object value : this.registry) {
            ((VisionDuck)value).vMinus$setVisionId(null);
        }
    }

    public void putVision(ResourceLocation id, Vision vision) {
        this.visions.put(id, vision);
    }

    public static void resetAllVisionTypes() {
        for (VisionType<?> visionType : VisionTypes.getAll()) {
            visionType.resetVisionTypes();
            visionType.visions.clear();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getMultiList() {
        return this.multiList;
    }

    @Contract(pure=true)
    @NotNull
    public String getDirectory() {
        return "visions/" + this.multiList;
    }

    public Registry<? extends T> getRegistry() {
        return this.registry;
    }

    public Function<ResourceLocation, ?> getRegistryGetter() {
        return this.registryGetter;
    }

    public BiConsumer<Object, ResourceLocation> getVisionSetter() {
        return this.visionSetter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VisionType that = (VisionType)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.multiList, that.multiList) && Objects.equals(this.registry, that.registry) && Objects.equals(this.registryGetter, that.registryGetter) && Objects.equals(this.visionSetter, that.visionSetter);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.multiList, this.registry, this.registryGetter, this.visionSetter);
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "VisionType[id=" + this.id + "]";
    }
}

