/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.lixir.vminus.resources.data.vision.VisionFormatter;
import net.lixir.vminus.resources.data.vision.VisionManager;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.util.NbtConversionUtil;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionEntry;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.VisionProperty;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.values.VisionValue;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class Vision {
    public static final Vision EMPTY = new Vision((ImmutableMap<String, VisionValue<?>[]>)ImmutableMap.of());
    private static final Set<Vision> UNIQUE_VISION_POOL = new HashSet<Vision>();
    private final ImmutableMap<String, VisionValue<?>[]> values;

    private Vision(ImmutableMap<String, VisionValue<?>[]> valueMap) {
        this.values = valueMap;
    }

    @NotNull
    public static Vision get(@NotNull VisionType<?> visionType, @Nullable ResourceLocation id) {
        return visionType.getVisions().getOrDefault(id, EMPTY);
    }

    @NotNull
    public static Vision getOrAddVision(@NotNull VisionType<?> visionType, ResourceLocation id, Vision vision) {
        for (Vision existing : List.copyOf(UNIQUE_VISION_POOL)) {
            if (!existing.equals(vision)) continue;
            visionType.putVision(id, existing);
            return existing;
        }
        UNIQUE_VISION_POOL.add(vision);
        visionType.putVision(id, vision);
        return vision;
    }

    @NotNull
    public static Vision get(@NotNull ItemStack stack) {
        return Vision.get(stack.m_41720_());
    }

    @NotNull
    public static Vision get(@NotNull Entity entity) {
        return Vision.get(entity.m_6095_());
    }

    @NotNull
    public static Vision get(@NotNull EntityType<?> entityType) {
        return Vision.get((VisionDuck)entityType);
    }

    @NotNull
    public static Vision get(@NotNull Item item) {
        return Vision.get((VisionDuck)item);
    }

    @NotNull
    public static Vision get(@NotNull BlockState state) {
        return Vision.get(state.m_60734_());
    }

    @NotNull
    public static Vision get(@NotNull Block block) {
        return Vision.get((VisionDuck)block);
    }

    @NotNull
    public static Vision get(@NotNull VisionDuck visionDuck) {
        ResourceLocation id = visionDuck.vMinus$getVisionId();
        VisionType<?> visionType = visionDuck.vMinus$getVisionType();
        return Vision.get(visionType, id);
    }

    public static void resetVisions() {
        VisionManager.clearVisionManagers();
        VisionType.resetAllVisionTypes();
        UNIQUE_VISION_POOL.clear();
    }

    @NotNull
    public static <T> Vision fromEntry(ResourceLocation visionId, @NotNull VisionEntry<T> visionEntry, @NotNull VisionType<?> visionType) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, List<VisionValue<?>>> entry : visionEntry.getValues().entrySet()) {
            String id = entry.getKey();
            List<VisionValue<?>> valuesList = entry.getValue();
            ArrayList filteredValues = new ArrayList();
            VisionValue<?> constantValue = null;
            for (VisionValue<?> visionValue : valuesList) {
                filteredValues.add(visionValue);
                if (constantValue != null && visionValue.getPriority() <= constantValue.getPriority()) continue;
                if (constantValue == null && visionValue.isConstant()) {
                    constantValue = visionValue;
                    continue;
                }
                if (constantValue == null) continue;
                if (visionValue.isConstant()) {
                    filteredValues.remove(constantValue);
                    constantValue = visionValue;
                    continue;
                }
                filteredValues.remove(constantValue);
                constantValue = null;
            }
            VisionValue[] visionProperties = new VisionValue[filteredValues.size()];
            for (int i = 0; i < visionProperties.length; ++i) {
                visionProperties[i] = (VisionValue)filteredValues.get(i);
            }
            builder.put((Object)id, (Object)visionProperties);
        }
        Vision newVision = new Vision((ImmutableMap<String, VisionValue<?>[]>)builder.build());
        return Vision.getOrAddVision(visionType, visionId, newVision);
    }

    public static void decode(ResourceLocation id, @NotNull CompoundTag originalTag, @NotNull VisionType<?> visionType) {
        CompoundTag compoundTag = originalTag.m_6426_();
        JsonObject jsonObject = NbtConversionUtil.compoundToJson(compoundTag);
        jsonObject = VisionFormatter.processJson(visionType.getId(), visionType.getMultiList(), (JsonElement)jsonObject);
        List<VisionProperty<?>> propertyTypes = VisionProperties.fromVisionType(visionType);
        VisionEntry visionEntry = new VisionEntry();
        for (VisionProperty<?> property : propertyTypes) {
            String propertyId = property.getId();
            if (!jsonObject.has(propertyId)) continue;
            VisionCodec<?> propertyCodec = property.getCodec();
            List<VisionValue<?>> parsedList = propertyCodec.decode(jsonObject, propertyId);
            visionEntry.addValues(propertyId, parsedList);
        }
        Vision.fromEntry(id, visionEntry, visionType);
    }

    @Nullable
    public static <T> T getValue(@NotNull EntityType<?> entityType, @NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        return Vision.get(entityType).getValue(visionProperty.getId(), visionContext);
    }

    @Nullable
    public static <T> T getValue(@NotNull EntityType<?> entityType, @NotNull VisionProperty<T> visionProperty) {
        return Vision.getValue(entityType, visionProperty, new VisionContext(entityType));
    }

    @Nullable
    public static <T> T getValue(@NotNull Entity entity, @NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        return Vision.get(entity).getValue(visionProperty.getId(), visionContext);
    }

    @Nullable
    public static <T> T getValue(@NotNull Entity entity, @NotNull VisionProperty<T> visionProperty) {
        return Vision.getValue(entity, visionProperty, new VisionContext(entity));
    }

    @Nullable
    public static <T> T getValue(@NotNull BlockState state, @NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        return Vision.get(state).getValue(visionProperty.getId(), visionContext);
    }

    @Nullable
    public static <T> T getValue(@NotNull BlockState state, @NotNull VisionProperty<T> visionProperty) {
        return Vision.getValue(state, visionProperty, new VisionContext((BlockBehaviour.BlockStateBase)state));
    }

    @Nullable
    public static <T> T getValue(@NotNull Item item, @NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        return Vision.get(item).getValue(visionProperty.getId(), visionContext);
    }

    @Nullable
    public static <T> T getValue(@NotNull Item item, @NotNull VisionProperty<T> visionProperty) {
        return Vision.getValue(item, visionProperty, new VisionContext(item));
    }

    @Nullable
    public static <T> T getValue(@NotNull ItemStack itemStack, @NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        return Vision.get(itemStack).getValue(visionProperty.getId(), visionContext);
    }

    @Nullable
    public static <T> T getValue(@NotNull ItemStack itemStack, @NotNull VisionProperty<T> visionProperty) {
        return Vision.getValue(itemStack, visionProperty, new VisionContext(itemStack));
    }

    private static <T> void encodeProperty(@NotNull VisionProperty<T> propertyType, @NotNull VisionValue<?> visionValue, JsonArray jsonArray) {
        if (!propertyType.getCodec().getClassType().isInstance(visionValue.getValue())) {
            throw new IllegalStateException("Type mismatch for VisionProperty: expected " + propertyType.getCodec().getClassType().getName() + " but got " + visionValue.getValue().getClass().getName());
        }
        VisionValue<?> casted = visionValue;
        JsonObject propertyObject = propertyType.getCodec().encode(casted.getValue());
        if (propertyObject != null) {
            jsonArray.add((JsonElement)propertyObject);
        }
    }

    public <T> T getValue(String id) {
        return this.getValue(id, null);
    }

    public <T> T getValue(@NotNull Vision vision, String id) {
        return vision.getValue(id, null);
    }

    @Nullable
    public <T> T getValue(@NotNull VisionProperty<T> visionProperty) {
        return this.getValue(visionProperty.getId(), null);
    }

    public <T> List<T> getValues(String id) {
        return (List)this.getValue(id, null);
    }

    @Nullable
    public <T> T getValue(@NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        return this.getValue(visionProperty.getId(), visionContext);
    }

    @Nullable
    public <T> T getValue(String id, @Nullable VisionContext visionContext) {
        VisionValue[] visionProperties = (VisionValue[])this.values.getOrDefault((Object)id, null);
        if (visionProperties == null) {
            return null;
        }
        for (VisionValue visionValue : visionProperties) {
            Object value = visionValue.getValue();
            if (!visionValue.testConditions(visionContext)) continue;
            return value;
        }
        return null;
    }

    public <T> List<T> getValues(@NotNull VisionProperty<T> visionProperty) {
        return this.getValues(visionProperty.getId(), null);
    }

    public <T> List<T> getValues(@NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        return this.getValues(visionProperty.getId(), visionContext);
    }

    public <T> List<T> getValues(String id, @Nullable VisionContext visionContext) {
        VisionValue[] visionProperties = (VisionValue[])this.values.getOrDefault((Object)id, null);
        if (visionProperties == null) {
            return Collections.emptyList();
        }
        ArrayList valueList = new ArrayList();
        for (VisionValue visionValue : visionProperties) {
            Object value = visionValue.getValue();
            if (!visionValue.testConditions(visionContext)) continue;
            valueList.add(value);
        }
        return valueList;
    }

    @NotNull
    public <T> CompoundTag encode(VisionType<T> visionType) {
        JsonObject root = new JsonObject();
        for (Map.Entry entry : this.values.entrySet()) {
            String id = (String)entry.getKey();
            VisionValue[] visionProperties = (VisionValue[])entry.getValue();
            JsonArray jsonArray = new JsonArray();
            VisionProperty<T> property = VisionProperties.get(visionType, id);
            if (property == null) {
                throw new RuntimeException("Could not find property type: " + id);
            }
            if (!property.shouldSyncToClient()) continue;
            for (VisionValue visionValue : visionProperties) {
                Vision.encodeProperty(property, visionValue, jsonArray);
            }
            if (jsonArray.isEmpty()) continue;
            root.add(id, (JsonElement)jsonArray);
        }
        return NbtConversionUtil.jsonToCompound(root);
    }

    public ImmutableMap<String, VisionValue<?>[]> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vision vision = (Vision)o;
        return this.values.equals(vision.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Vision {").append("\n");
        for (Map.Entry entry : this.values.entrySet()) {
            sb.append("  ").append((String)entry.getKey()).append(" = [");
            VisionValue[] visionProperties = (VisionValue[])entry.getValue();
            for (int i = 0; i < visionProperties.length; ++i) {
                sb.append(visionProperties[i]);
                if (i >= visionProperties.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]").append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

