/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionParticleCodec
extends VisionCodec<ParticleType<?>> {
    @Override
    public Class<ParticleType<?>> getClassType() {
        return ParticleType.class;
    }

    @Override
    @Nullable
    public List<VisionValue<ParticleType<?>>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList visionProperties = new ArrayList();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            ResourceLocation resourceLocation = VisionParticleCodec.parseResourceLocation(key, arrayObject);
            ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(resourceLocation);
            visionProperties.add(VisionValue.create(particleType, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull ParticleType<?> value) {
        JsonObject jsonObject = new JsonObject();
        ResourceLocation id = ForgeRegistries.PARTICLE_TYPES.getKey(value);
        if (id == null) {
            throw new IllegalArgumentException("Unknown particle type: " + value);
        }
        jsonObject.addProperty("id", id.toString());
        return jsonObject;
    }
}

