/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.util.ItemReplacement;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionItemReplacementCodec
extends VisionCodec<ItemReplacement> {
    @Override
    public Class<ItemReplacement> getClassType() {
        return ItemReplacement.class;
    }

    @Override
    @Nullable
    public List<VisionValue<ItemReplacement>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<ItemReplacement>> visionProperties = new ArrayList<VisionValue<ItemReplacement>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement element : jsonArray) {
            ResourceLocation resourceLocation;
            Item item;
            JsonObject arrayObject = element.getAsJsonObject();
            String value = arrayObject.getAsJsonPrimitive("value").getAsString();
            if (value.startsWith("#")) {
                ResourceLocation tagLocation = new ResourceLocation(value.substring(1));
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLocation);
                ItemReplacement itemReplacement = new ItemReplacement(null, (TagKey<Item>)tagKey);
                visionProperties.add(VisionValue.create(itemReplacement, arrayObject, jsonObject, key));
                continue;
            }
            String baseId = value;
            String nbtString = null;
            int nbtStart = value.indexOf(123);
            if (nbtStart != -1) {
                baseId = value.substring(0, nbtStart);
                nbtString = value.substring(nbtStart);
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation = new ResourceLocation(baseId))) == null) {
                throw new JsonParseException(resourceLocation + " is not a valid item.");
            }
            ItemStack itemStack = item.m_7968_();
            if (nbtString != null) {
                try {
                    itemStack.m_41751_(TagParser.m_129359_((String)nbtString));
                }
                catch (Exception e) {
                    throw new JsonParseException("Invalid NBT for " + value + ": " + e.getMessage(), (Throwable)e);
                }
            }
            ItemReplacement itemReplacement = new ItemReplacement(itemStack, null);
            visionProperties.add(VisionValue.create(itemReplacement, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull ItemReplacement value) {
        JsonObject jsonObject = new JsonObject();
        if (value.tag() != null) {
            jsonObject.addProperty("value", "#" + value.tag().f_203868_());
        } else {
            ItemStack itemStack = value.itemStack();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            if (id == null) {
                throw new JsonParseException("Cannot encode ItemStack with unregistered item: " + itemStack);
            }
            StringBuilder sb = new StringBuilder(id.toString());
            if (itemStack.m_41782_()) {
                sb.append(itemStack.m_41783_().toString());
            }
            jsonObject.addProperty("value", sb.toString());
        }
        return jsonObject;
    }
}

