/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.util.VisionEntityVariant;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionEntityVariantCodec
extends VisionCodec<VisionEntityVariant> {
    @Override
    public Class<VisionEntityVariant> getClassType() {
        return VisionEntityVariant.class;
    }

    @Override
    @Nullable
    public List<VisionValue<VisionEntityVariant>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<VisionEntityVariant>> visionProperties = new ArrayList<VisionValue<VisionEntityVariant>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            if (!arrayObject.has("name")) {
                throw new JsonParseException(key + " has no name.");
            }
            ResourceLocation variantName = VisionEntityVariantCodec.parseResourceLocation("name", key, arrayObject);
            Integer weight = arrayObject.has("weight") ? arrayObject.getAsJsonPrimitive("weight").getAsInt() : 1;
            if (!arrayObject.has("texture")) {
                throw new JsonParseException(key + " has no texture.");
            }
            ResourceLocation variantTexture = VisionEntityVariantCodec.parseResourceLocation("texture", key, arrayObject);
            boolean replace = arrayObject.has("replace") && arrayObject.getAsJsonPrimitive("replace").getAsBoolean();
            VisionEntityVariant visionEntityVariant = new VisionEntityVariant(variantName, variantTexture, weight, replace);
            visionProperties.add(VisionValue.create(visionEntityVariant, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull VisionEntityVariant value) {
        JsonObject jsonObject = new JsonObject();
        if (value.name() == null || value.texture() == null) {
            return null;
        }
        jsonObject.addProperty("name", value.name().toString());
        jsonObject.addProperty("texture", value.texture().toString());
        jsonObject.addProperty("weight", (Number)value.weight());
        if (value.replace().booleanValue()) {
            jsonObject.addProperty("replace", Boolean.valueOf(true));
        }
        return jsonObject;
    }
}

