/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.util.CreativeOrder;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionCreativeOrderCodec
extends VisionCodec<CreativeOrder> {
    @Override
    public Class<CreativeOrder> getClassType() {
        return CreativeOrder.class;
    }

    @Override
    @Nullable
    public List<VisionValue<CreativeOrder>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<CreativeOrder>> visionProperties = new ArrayList<VisionValue<CreativeOrder>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            CreativeOrder order;
            boolean before;
            String targetValue;
            String itemValue;
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            if (arrayObject.has("value")) {
                String value = arrayObject.getAsJsonPrimitive("value").getAsString();
                if (value.contains(">")) {
                    parts = value.split(">");
                    if (parts.length != 2) {
                        throw new JsonParseException("Invalid value format for " + key + ": " + value);
                    }
                    itemValue = parts[0].trim();
                    targetValue = parts[1].trim();
                    before = false;
                } else if (value.contains("<")) {
                    parts = value.split("<");
                    if (parts.length != 2) {
                        throw new JsonParseException("Invalid value format for " + key + ": " + value);
                    }
                    itemValue = parts[0].trim();
                    targetValue = parts[1].trim();
                    before = true;
                } else {
                    itemValue = value;
                    targetValue = null;
                    before = false;
                }
            } else {
                itemValue = arrayObject.getAsJsonPrimitive("item").getAsString();
                targetValue = arrayObject.has("target") ? arrayObject.getAsJsonPrimitive("target").getAsString() : null;
                before = arrayObject.has("before") && arrayObject.get("before").isJsonPrimitive() && arrayObject.getAsJsonPrimitive("before").getAsBoolean();
            }
            ItemStack targetItemStack = null;
            if (targetValue != null) {
                ResourceLocation targetLoc = new ResourceLocation(targetValue);
                Item targetItem = (Item)ForgeRegistries.ITEMS.getValue(targetLoc);
                if (targetItem == null) {
                    throw new JsonParseException(targetLoc + " is not a valid target item for " + key + ".");
                }
                targetItemStack = targetItem.m_7968_();
            }
            if (itemValue.startsWith("#")) {
                ResourceLocation tagLoc = new ResourceLocation(itemValue.substring(1));
                TagKey itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLoc);
                order = new CreativeOrder(null, targetItemStack, before, (TagKey<Item>)itemTag);
            } else {
                ResourceLocation itemLoc = new ResourceLocation(itemValue);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLoc);
                if (item == null) {
                    throw new JsonParseException(itemLoc + " is not a valid item for " + key + ".");
                }
                ItemStack itemStack = item.m_7968_();
                order = new CreativeOrder(itemStack, targetItemStack, before, null);
            }
            visionProperties.add(VisionValue.create(order, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull CreativeOrder value) {
        ResourceLocation targetId;
        JsonObject jsonObject = new JsonObject();
        ResourceLocation itemId = value.getItemStack() != null ? ForgeRegistries.ITEMS.getKey((Object)value.getItemStack().m_41720_()) : null;
        ResourceLocation resourceLocation = targetId = value.getTargetItemStack() != null ? ForgeRegistries.ITEMS.getKey((Object)value.getTargetItemStack().m_41720_()) : null;
        if (itemId != null && targetId != null) {
            String arrow = value.isBefore() != false ? "<" : ">";
            jsonObject.addProperty("value", itemId + arrow + targetId);
            return jsonObject;
        }
        if (value.getTagKey() != null) {
            jsonObject.addProperty("item", "#" + value.getTagKey().f_203868_().toString());
        } else if (itemId != null) {
            jsonObject.addProperty("item", itemId.toString());
        }
        if (targetId != null) {
            jsonObject.addProperty("target", targetId.toString());
        }
        jsonObject.addProperty("before", value.isBefore());
        return jsonObject;
    }
}

