/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionBlockCodec
extends VisionCodec<Block> {
    @Override
    public Class<Block> getClassType() {
        return Block.class;
    }

    @Override
    @Nullable
    public List<VisionValue<Block>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<Block>> visionProperties = new ArrayList<VisionValue<Block>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            ResourceLocation resourceLocation = VisionBlockCodec.parseResourceLocation(key, arrayObject);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            if (block == null) {
                throw new JsonParseException(resourceLocation + " is not a valid block.");
            }
            visionProperties.add(VisionValue.create(block, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull Block value) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", BuiltInRegistries.f_256975_.m_7981_((Object)value).toString());
        return jsonObject;
    }
}

