/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.util.VisionAttribute;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionAttributeCodec
extends VisionCodec<VisionAttribute> {
    @Override
    public Class<VisionAttribute> getClassType() {
        return VisionAttribute.class;
    }

    @Override
    @Nullable
    public List<VisionValue<VisionAttribute>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<VisionAttribute>> visionProperties = new ArrayList<VisionValue<VisionAttribute>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            String name;
            AttributeModifier.Operation operation;
            String operationString;
            UUID uuid;
            String uuidString;
            double value;
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            if (arrayObject.has("value")) {
                if (!arrayObject.get("value").isJsonPrimitive()) {
                    throw new JsonParseException(arrayObject.get("value") + " is not a valid double.");
                }
                value = arrayObject.get("value").getAsJsonPrimitive().getAsDouble();
            } else {
                value = 0.0;
            }
            Boolean replace = arrayObject.has("replace") && arrayObject.get("replace").isJsonPrimitive() && arrayObject.getAsJsonPrimitive("replace").getAsBoolean();
            Boolean remove = arrayObject.has("remove") && arrayObject.get("remove").isJsonPrimitive() && arrayObject.getAsJsonPrimitive("remove").getAsBoolean();
            String string = uuidString = arrayObject.has("uuid") ? arrayObject.getAsJsonPrimitive("uuid").getAsString() : null;
            if (uuidString == null) {
                uuid = UUID.randomUUID();
            } else {
                try {
                    uuid = UUID.fromString(uuidString);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException(uuidString + " is not a valid UUID.");
                }
            }
            String id = arrayObject.getAsJsonPrimitive("id").getAsString();
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(id));
            if (attribute == null) {
                throw new JsonParseException(id + " is not a valid attribute.");
            }
            String string2 = operationString = arrayObject.has("operation") ? arrayObject.getAsJsonPrimitive("operation").getAsString() : "addition";
            if (operationString != null) {
                try {
                    operation = AttributeModifier.Operation.valueOf((String)operationString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException(operationString + " is not a valid operation.");
                }
            } else {
                operation = AttributeModifier.Operation.ADDITION;
            }
            String slotString = arrayObject.has("slot") ? arrayObject.getAsJsonPrimitive("slot").getAsString() : null;
            EquipmentSlot equipmentSlot = null;
            if (slotString != null) {
                try {
                    equipmentSlot = EquipmentSlot.valueOf((String)slotString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException(slotString + " is not a valid equipment slot.");
                }
            }
            String string3 = name = arrayObject.has("id") ? arrayObject.getAsJsonPrimitive("id").getAsString() : null;
            if (name == null) {
                if (id.contains(".")) {
                    name = id.substring(id.indexOf(".") + 1);
                } else if (id.contains(":")) {
                    name = id.substring(id.indexOf(":") + 1);
                }
                if (name != null) {
                    name = name.replaceAll("_", " ");
                }
            }
            if (name == null) {
                throw new JsonParseException("Name is null.");
            }
            AttributeModifier attributeModifier = new AttributeModifier(uuid, name, value, operation);
            VisionAttribute visionAttribute = new VisionAttribute(remove, replace, attributeModifier, attribute, equipmentSlot, id);
            visionProperties.add(VisionValue.create(visionAttribute, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull VisionAttribute visionAttribute) {
        EquipmentSlot slot;
        JsonObject jsonObject = new JsonObject();
        AttributeModifier modifier = visionAttribute.attributeModifier();
        jsonObject.addProperty("uuid", modifier.m_22209_().toString());
        jsonObject.addProperty("id", visionAttribute.id());
        jsonObject.addProperty("value", (Number)modifier.m_22218_());
        jsonObject.addProperty("operation", modifier.m_22217_().name().toLowerCase());
        if (visionAttribute.replace().booleanValue()) {
            jsonObject.addProperty("replace", Boolean.valueOf(true));
        }
        if (visionAttribute.remove().booleanValue()) {
            jsonObject.addProperty("remove", Boolean.valueOf(true));
        }
        if ((slot = visionAttribute.equipmentSlot()) != null) {
            jsonObject.addProperty("slot", slot.name().toLowerCase());
        }
        return jsonObject;
    }
}

