/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry.entry.group;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.lixir.vminus.registry.entry.group.RegistryEntryGroup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class RegistryEntryGroupsProvider {
    private static final Map<Class<?>, RegistryEntryGroup<?>> ASSIGNED_ENTRIES = new ConcurrentHashMap();
    private static final Map<Supplier<Object>, RegistryEntryGroup<?>> ASSIGNED_SUPPLIERS = new ConcurrentHashMap();

    public abstract void run();

    public static <T> void assign(@NotNull RegistryEntryGroup<T> group, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            ASSIGNED_ENTRIES.put(clazz, group);
        }
    }

    @SafeVarargs
    public static <T> void assign(@NotNull RegistryEntryGroup<T> group, Supplier<Object> ... suppliers) {
        for (Supplier<Object> supplier : suppliers) {
            ASSIGNED_SUPPLIERS.put(supplier, group);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static Map<Supplier<Object>, RegistryEntryGroup<?>> getAssignedSuppliers() {
        return ASSIGNED_SUPPLIERS;
    }

    @Contract(pure=true)
    @NotNull
    public static Map<Class<?>, RegistryEntryGroup<?>> getAssignedEntries() {
        return ASSIGNED_ENTRIES;
    }

    @NotNull
    public static Supplier<Object> deferredBlock(String namespace, String path) {
        return RegistryEntryGroupsProvider.deferredBlock(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    @NotNull
    public static Supplier<Object> deferredBlock(ResourceLocation resourceLocation) {
        return () -> BuiltInRegistries.f_256975_.m_7745_(resourceLocation);
    }
}

