/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.lixir.vminus.resources.data.sight.SightManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record ClientboundSightSyncPacket(Map<String, Boolean> sights) {
    public static void encode(@NotNull ClientboundSightSyncPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130130_(msg.sights.size());
        for (Map.Entry<String, Boolean> entry : msg.sights.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.writeBoolean(entry.getValue().booleanValue());
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ClientboundSightSyncPacket decode(@NotNull FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130277_();
            boolean value = buf.readBoolean();
            map.put(key, value);
        }
        return new ClientboundSightSyncPacket(map);
    }

    public static void handle(ClientboundSightSyncPacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SightManager.setAll(msg.sights));
        ctx.get().setPacketHandled(true);
    }
}

