/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.items;

import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.lixir.vminus.vision.util.VisionFoodProperties;
import net.lixir.vminus.vision.util.VisionUtils;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements IForgeItemStack,
VisionDuck {
    @Unique
    private final ItemStack vMinus$self = (ItemStack)this;

    @Shadow
    public abstract Item m_41720_();

    @Override
    public @NonNull VisionType<?> vMinus$getVisionType() {
        return VisionTypes.ITEM;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVisionId() {
        return ((VisionDuck)this.m_41720_()).vMinus$getVisionId();
    }

    @Inject(method={"getBarWidth"}, at={@At(value="RETURN")}, cancellable=true)
    private void getBarWidth(CallbackInfoReturnable<Integer> cir) {
        Integer maxDamage = VisionUtils.getOverrideValue(this, VisionProperties.Items.MAX_DAMAGE, new VisionContext(this.vMinus$self));
        if (this.vMinus$self.m_41763_() && maxDamage != null && maxDamage > 0) {
            float durabilityRatio = 1.0f - (float)this.vMinus$self.m_41773_() / (float)this.vMinus$self.m_41776_();
            int barWidth = (int)Math.floor(13.0f * durabilityRatio);
            cir.setReturnValue((Object)Math.min(barWidth, 13));
        }
    }

    @Inject(method={"isBarVisible"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$isBarVisible(CallbackInfoReturnable<Boolean> cir) {
        Integer maxDamage = VisionUtils.getOverrideValue(this, VisionProperties.Items.MAX_DAMAGE, new VisionContext(this.vMinus$self));
        if (maxDamage != null && this.vMinus$self.m_41768_()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isEnchantable"}, at={@At(value="RETURN")}, cancellable=true)
    private void isEnchantable(CallbackInfoReturnable<Boolean> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.ENCHANTABLE, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getDrinkingSound"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getDrinkingSound(CallbackInfoReturnable<SoundEvent> cir) {
        this.vMinus$trySetEatSound(cir);
    }

    @Inject(method={"getEatingSound"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getEatingSound(CallbackInfoReturnable<SoundEvent> cir) {
        this.vMinus$trySetEatSound(cir);
    }

    @Unique
    private void vMinus$trySetEatSound(CallbackInfoReturnable<SoundEvent> cir) {
        VisionFoodProperties visionFoodProperties = VisionUtils.getOverrideValue(this, VisionProperties.Items.FOOD, new VisionContext(this.vMinus$self));
        if (visionFoodProperties == null) {
            return;
        }
        SoundEvent eatSound = visionFoodProperties.eatSound();
        if (eatSound != null) {
            cir.setReturnValue((Object)eatSound);
        }
    }

    @Inject(method={"getUseDuration"}, at={@At(value="RETURN")}, cancellable=true)
    private void getUseDuration(CallbackInfoReturnable<Integer> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.USE_TICKS, new VisionContext(this.vMinus$self));
    }
}

