/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.forge.registries;

import java.util.Collection;
import java.util.List;
import net.lixir.vminus.vision.util.VisionUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeRegistry.class})
public abstract class ForgeRegistryMixin<V> {
    @Shadow
    public abstract boolean isEmpty();

    @Shadow
    public abstract ResourceLocation getKey(V var1);

    @Inject(method={"getValues"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void vMinus$getValues(@NotNull CallbackInfoReturnable<Collection<V>> cir) {
        Collection original = (Collection)cir.getReturnValue();
        List<Object> filtered = original.stream().filter(value -> {
            if (value instanceof Item) {
                Item item = (Item)value;
                return VisionUtils.isBanned(item);
            }
            return true;
        }).toList();
        if (!filtered.equals(original)) {
            cir.setReturnValue(filtered);
        }
    }
}

