/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.entities;

import net.lixir.vminus.entity.VariantEntity;
import net.lixir.vminus.entity.attribute.VMinusAttributes;
import net.lixir.vminus.item.IEquipmentItem;
import net.lixir.vminus.network.ServerboundJumpPacket;
import net.lixir.vminus.network.VMinusNetwork;
import net.lixir.vminus.resources.data.sight.SightManager;
import net.lixir.vminus.util.SizeAttributeUtil;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements VariantEntity,
VisionDuck {
    @Shadow
    protected boolean f_20899_;
    @Shadow
    private int f_20954_;
    @Unique
    private ResourceLocation vMinus$variantTexture = null;
    @Unique
    private ResourceLocation vMinus$variantName = null;
    @Unique
    private boolean vminus$wasJumping = false;
    @Unique
    private final LivingEntity vMinus$self = (LivingEntity)this;
    @Unique
    private float vMinus$lastWidthScale = 1.0f;
    @Unique
    private float vMinus$lastHeightScale = 1.0f;

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void vMinus$setVariant(@Nullable ResourceLocation name, @Nullable ResourceLocation texture) {
        this.vMinus$variantName = name != null && name.m_135815_().isEmpty() ? null : name;
        this.vMinus$variantTexture = texture != null && texture.m_135815_().isEmpty() ? null : texture;
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void vminus$onJumpTick(CallbackInfo ci) {
        ItemStack boots;
        Item item;
        boolean justPressedJump;
        boolean jumpingNow = this.f_20899_;
        boolean bl = justPressedJump = jumpingNow && !this.vminus$wasJumping;
        if (justPressedJump && !this.m_20096_() && !this.m_6047_() && this.f_20954_ == 0 && (item = (boots = this.m_6844_(EquipmentSlot.FEET)).m_41720_()) instanceof IEquipmentItem) {
            IEquipmentItem IEquipmentItem2 = (IEquipmentItem)item;
            if (this.m_9236_().f_46443_) {
                IEquipmentItem2.onEntityJump(this.m_9236_(), this.vMinus$self, boots, false);
                VMinusNetwork.CHANNEL.sendToServer((Object)new ServerboundJumpPacket(this.m_19879_(), false));
            }
        }
        this.vminus$wasJumping = jumpingNow;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVariantTexture() {
        return this.vMinus$variantTexture;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVariantName() {
        return this.vMinus$variantName;
    }

    @Inject(method={"getLootTable"}, at={@At(value="RETURN")}, cancellable=true)
    public final void vMinus$getLootTable(CallbackInfoReturnable<ResourceLocation> cir) {
        this.vMinus$self.getPersistentData();
        if (this.vMinus$self.getPersistentData().m_128441_("variant")) {
            String variant = this.vMinus$self.getPersistentData().m_128461_("variant");
            String entityName = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.vMinus$self.m_6095_()).m_135815_();
            if (!variant.equals("normal")) {
                ResourceLocation customLoot = new ResourceLocation("vminus:entities/variant/" + entityName + "/" + variant);
                cir.setReturnValue((Object)customLoot);
            }
        }
    }

    @Override
    public @NonNull VisionType<?> vMinus$getVisionType() {
        return VisionTypes.ENTITY;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVisionId() {
        return ((VisionDuck)this.m_6095_()).vMinus$getVisionId();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public final void vMinus$addAdditionalSaveData(@NotNull CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128359_("VariantTexture", this.vMinus$variantTexture == null ? "null" : this.vMinus$variantTexture.toString());
        compoundTag.m_128359_("VariantName", this.vMinus$variantName == null ? "null" : this.vMinus$variantName.toString());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public final void vMinus$readAdditionalSaveDataCompoundTag(@NotNull CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.m_128441_("VariantName")) {
            ResourceLocation resourceLocation = this.vMinus$variantName = compoundTag.m_128461_("VariantName").equals("null") ? null : ResourceLocation.parse((String)compoundTag.m_128461_("VariantName"));
        }
        if (compoundTag.m_128441_("VariantTexture")) {
            this.vMinus$variantTexture = compoundTag.m_128461_("VariantTexture").equals("null") ? null : ResourceLocation.parse((String)compoundTag.m_128461_("VariantTexture"));
        }
    }

    @Inject(method={"getJumpBoostPower"}, at={@At(value="RETURN")}, cancellable=true)
    public void getJumpBoostPower(CallbackInfoReturnable<Float> cir) {
        float increase = 0.0f;
        if (this.vMinus$self.m_21204_().m_22171_(VMinusAttributes.JUMP_BOOST)) {
            increase += (float)this.vMinus$self.m_21133_(VMinusAttributes.JUMP_BOOST) * 0.15f;
        }
        if (increase != 0.0f) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * increase * SizeAttributeUtil.getHeight(this.vMinus$self) * 0.2f));
        }
    }

    @Inject(method={"getDimensions"}, at={@At(value="RETURN")}, cancellable=true)
    public final void vMinus$getDimensions(Pose pose, @NotNull CallbackInfoReturnable<EntityDimensions> cir) {
        if (!SightManager.get("size_attributes")) {
            return;
        }
        float defaultHeight = ((EntityDimensions)cir.getReturnValue()).f_20378_;
        float defaultWidth = ((EntityDimensions)cir.getReturnValue()).f_20377_;
        float widthScale = SizeAttributeUtil.getWidth(this.vMinus$self);
        float heightScale = SizeAttributeUtil.getHeight(this.vMinus$self);
        float width = defaultWidth * widthScale;
        float height = defaultHeight * heightScale;
        if (width != defaultWidth || height != defaultHeight) {
            cir.setReturnValue((Object)EntityDimensions.m_20395_((float)width, (float)height));
        }
        this.vMinus$lastWidthScale = widthScale;
        this.vMinus$lastHeightScale = heightScale;
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public final void vMinus$baseTick(CallbackInfo ci) {
        if (!SightManager.get("size_attributes")) {
            return;
        }
        if (this.vMinus$self == null) {
            return;
        }
        float widthScale = SizeAttributeUtil.getWidth(this.vMinus$self);
        float heightScale = SizeAttributeUtil.getHeight(this.vMinus$self);
        if (widthScale != this.vMinus$lastWidthScale || heightScale != this.vMinus$lastHeightScale) {
            this.vMinus$self.m_6210_();
            this.vMinus$lastWidthScale = widthScale;
            this.vMinus$lastHeightScale = heightScale;
        }
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void createLivingAttributes(@NotNull CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.WIDTH);
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.HEIGHT);
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.PROTECTION);
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.FALL_PROTECTION);
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.FIRE_PROTECTION);
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.BLUNT_PROTECTION);
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.BLAST_PROTECTION);
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(VMinusAttributes.MAGIC_PROTECTION);
    }
}

