/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.enchantments;

import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.lixir.vminus.vision.util.EnchantmentVisionHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentMixin
implements VisionDuck {
    @Unique
    private final Enchantment vMinus$self = (Enchantment)this;
    @Unique
    private ResourceLocation vMinus$visionId = null;

    @Inject(method={"getMinLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void getMinLevel(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.getMinLevel(this.vMinus$self, cir.getReturnValue() != null ? (Integer)cir.getReturnValue() : 1));
    }

    @Inject(method={"getMaxLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void getMaxLevel(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.getMaxLevel(this.vMinus$self, cir.getReturnValue() != null ? (Integer)cir.getReturnValue() : 1));
    }

    @Inject(method={"isTreasureOnly"}, at={@At(value="RETURN")}, cancellable=true)
    private void isTreasureOnly(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isTreasure(this.vMinus$self, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"isCurse"}, at={@At(value="RETURN")}, cancellable=true)
    private void isCurse(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isCurse(this.vMinus$self, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"canEnchant"}, at={@At(value="RETURN")}, cancellable=true)
    private void canEnchant(ItemStack itemstack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.canEnchant(this.vMinus$self, itemstack, (Boolean)cir.getReturnValue()));
    }

    @Inject(method={"isCompatibleWith"}, at={@At(value="RETURN")}, cancellable=true)
    private void isCompatibleWith(Enchantment otherEnchantment, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isCompatible(this.vMinus$self, otherEnchantment, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"isTradeable"}, at={@At(value="RETURN")}, cancellable=true)
    private void isTradeable(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isTradeable(this.vMinus$self, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"isDiscoverable"}, at={@At(value="RETURN")}, cancellable=true)
    private void isDiscoverable(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.isDiscoverable(this.vMinus$self, cir.getReturnValue() != null ? (Boolean)cir.getReturnValue() : false));
    }

    @Inject(method={"getRarity"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRarity(CallbackInfoReturnable<Enchantment.Rarity> cir) {
        cir.setReturnValue((Object)EnchantmentVisionHelper.getRarity(this.vMinus$self, (Enchantment.Rarity)cir.getReturnValue()));
    }

    @Override
    public void vMinus$setVisionId(@Nullable ResourceLocation id) {
        this.vMinus$visionId = id;
    }

    @Override
    public @NonNull VisionType<?> vMinus$getVisionType() {
        return VisionTypes.ENCHANTMENT;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVisionId() {
        return this.vMinus$visionId;
    }
}

