/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.creative;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.lixir.vminus.mixins.creative.CreativeTabModeAccessor;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.lixir.vminus.vision.util.CreativeOrder;
import net.lixir.vminus.vision.util.ItemReplacement;
import net.lixir.vminus.vision.util.ItemStackWrapper;
import net.lixir.vminus.vision.util.VisionUtils;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeTab.class}, priority=12000)
public class CreativeModeTabMixin
implements VisionDuck {
    @Unique
    private final CreativeModeTab vMinus$self = (CreativeModeTab)this;
    @Unique
    private HashMap<Item, Item> WAITING_LIST = new HashMap();
    @Unique
    private HashMap<Item, Boolean> WAITING_LIST_ORDER = new HashMap();
    @Unique
    private ResourceLocation vMinus$visionId = null;

    @Inject(method={"getIconItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getIconItem(CallbackInfoReturnable<ItemStack> cir) {
        ItemStack chosenItemStack = (ItemStack)cir.getReturnValue();
        ItemStackWrapper visionIconItemStack = VisionUtils.getOverrideValue((VisionDuck)this.vMinus$self, VisionProperties.Tabs.ICON, null);
        if (visionIconItemStack != null) {
            chosenItemStack = visionIconItemStack.itemStack();
        }
        chosenItemStack.m_41784_().m_128379_("tab_item", true);
        cir.setReturnValue((Object)chosenItemStack);
    }

    @Inject(method={"buildContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/CreativeModeTab;rebuildSearchTree()V")})
    private void vMinus$buildContents(CreativeModeTab.ItemDisplayParameters displayContext, CallbackInfo ci) {
        boolean updated;
        CreativeTabModeAccessor accessor = (CreativeTabModeAccessor)this.vMinus$self;
        Vision vision = Vision.get((VisionDuck)this.vMinus$self);
        List<CreativeOrder> creativeOrders = vision.getValues(VisionProperties.Tabs.ORDER);
        List<ItemReplacement> removals = vision.getValues(VisionProperties.Tabs.REMOVE);
        ArrayList<Item> itemsToRemove = new ArrayList<Item>(removals.stream().filter(t -> t.itemStack() != null).map(t -> t.itemStack().m_41720_()).toList());
        ArrayList<TagKey<Item>> itemTagsToRemove = new ArrayList<TagKey<Item>>(removals.stream().map(ItemReplacement::tag).filter(Objects::nonNull).toList());
        this.vminus$processHiddenItems(accessor.getDisplayItems(), itemsToRemove, itemTagsToRemove);
        this.vminus$processHiddenItems(accessor.getSearchItems(), itemsToRemove, itemTagsToRemove);
        ArrayList<CreativeOrder> orders = new ArrayList<CreativeOrder>(creativeOrders);
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(accessor.getDisplayItems());
        orders.sort(Comparator.comparingInt(order -> {
            ItemStack targetStack = order.getTargetItemStack();
            return targetStack != null ? this.vminus$findItemIndex(itemList, targetStack.m_41720_()) : Integer.MAX_VALUE;
        }));
        for (CreativeOrder order2 : orders) {
            ItemStack itemStack = order2.getItemStack();
            TagKey<Item> tagKey = order2.getTagKey();
            ItemStack targetItemStack = order2.getTargetItemStack();
            if (itemStack != null) {
                Item item = itemStack.m_41720_();
                if (targetItemStack != null) {
                    Item targetItem = targetItemStack.m_41720_();
                    this.vminus$addItemsToTab(targetItem, item, order2.isBefore());
                    continue;
                }
                if (!accessor.getDisplayItems().contains(itemStack)) {
                    accessor.getDisplayItems().add(itemStack);
                }
                accessor.getSearchItems().add(itemStack);
                continue;
            }
            if (tagKey == null) continue;
            if (targetItemStack != null) {
                Item targetItem = targetItemStack.m_41720_();
                BuiltInRegistries.f_257033_.m_206058_(tagKey).forEach(taggedItem -> {
                    ItemStack stack = new ItemStack((ItemLike)taggedItem.m_203334_());
                    this.vminus$addItemsToTab(targetItem, stack.m_41720_(), order2.isBefore());
                });
                continue;
            }
            BuiltInRegistries.f_257033_.m_206058_(tagKey).forEach(taggedItem -> {
                ItemStack stack = new ItemStack((ItemLike)taggedItem.m_203334_());
                if (!accessor.getDisplayItems().contains(stack)) {
                    accessor.getDisplayItems().add(stack);
                }
                accessor.getSearchItems().add(stack);
            });
        }
        do {
            updated = false;
            Iterator<Map.Entry<Item, Item>> iterator = this.WAITING_LIST.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Item, Item> entry = iterator.next();
                Item item = entry.getKey();
                Item targetItem = entry.getValue();
                boolean before = this.WAITING_LIST_ORDER.getOrDefault(item, false);
                if (!accessor.getDisplayItems().contains(new ItemStack((ItemLike)targetItem))) continue;
                this.vminus$addItemsToTab(targetItem, item, before);
                iterator.remove();
                this.WAITING_LIST_ORDER.remove(item);
                updated = true;
            }
        } while (updated);
        this.WAITING_LIST.clear();
        this.WAITING_LIST_ORDER.clear();
        this.vMinus$self.m_257466_();
    }

    @Unique
    private void vminus$processHiddenItems(@NotNull Collection<ItemStack> itemStacks, List<Item> itemsToRemove, List<TagKey<Item>> itemTagsToRemove) {
        ITagManager tagCollection = ForgeRegistries.ITEMS.tags();
        for (ItemStack itemStack2 : itemStacks) {
            if (itemStack2 == null) continue;
            Item item = itemStack2.m_41720_();
            VisionDuck visionDuck = (VisionDuck)item;
            Boolean ban = VisionUtils.getOverrideValue(visionDuck, VisionProperties.Items.BAN, new VisionContext(itemStack2));
            ItemReplacement itemReplacement = VisionUtils.getOverrideValue(visionDuck, VisionProperties.Items.REPLACE, new VisionContext(itemStack2));
            boolean isTaggedForRemoval = itemTagsToRemove.stream().anyMatch(tagKey -> tagCollection != null && tagCollection.getTag(tagKey).contains((Object)item));
            if ((ban == null || !ban.booleanValue()) && (itemReplacement == null || itemReplacement.itemStack() == null && itemReplacement.tag() == null) && !itemsToRemove.contains(item) && !isTaggedForRemoval) continue;
            itemsToRemove.add(item);
        }
        itemStacks.removeIf(itemStack -> itemsToRemove.contains(itemStack.m_41720_()) || tagCollection != null && itemTagsToRemove.stream().anyMatch(tagKey -> tagCollection.getTag(tagKey).contains((Object)itemStack.m_41720_())));
    }

    @Unique
    private void vminus$addItemsToTab(@Nullable Item targetItem, Item item, boolean before) {
        Boolean ban = VisionUtils.getOverrideValue((VisionDuck)item, VisionProperties.Items.BAN, new VisionContext(item));
        if (ban != null && ban.booleanValue()) {
            return;
        }
        Boolean targetBan = VisionUtils.getOverrideValue((VisionDuck)targetItem, VisionProperties.Items.BAN, new VisionContext(targetItem));
        if (targetBan != null && targetBan.booleanValue()) {
            return;
        }
        CreativeTabModeAccessor accessor = (CreativeTabModeAccessor)this.vMinus$self;
        Collection<ItemStack> items = accessor.getDisplayItems();
        Set<ItemStack> searchTabItems = accessor.getSearchItems();
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(items);
        if (itemList.isEmpty()) {
            return;
        }
        int targetIndex = this.vminus$findItemIndex(itemList, targetItem);
        ItemStack newItemStack = item.m_7968_();
        if (newItemStack.m_41619_()) {
            return;
        }
        if (this.vminus$containsItem(itemList, item)) {
            itemList.remove(newItemStack);
        }
        if (this.vminus$containsItem(searchTabItems, item)) {
            searchTabItems.remove(newItemStack);
        }
        if (targetIndex == -1 || targetItem == null) {
            this.WAITING_LIST.put(item, targetItem);
            this.WAITING_LIST_ORDER.put(item, before);
            return;
        }
        itemList.add(before ? targetIndex : targetIndex + 1, newItemStack);
        items.clear();
        items.addAll(itemList);
        LinkedHashSet<ItemStack> newSearchTabItems = new LinkedHashSet<ItemStack>(searchTabItems);
        if (!this.vminus$containsItem(newSearchTabItems, item)) {
            newSearchTabItems.add(newItemStack);
        }
        searchTabItems.clear();
        searchTabItems.addAll(newSearchTabItems);
    }

    @Unique
    private int vminus$findItemIndex(@NotNull List<ItemStack> items, Item targetItem) {
        for (int i = 0; i < items.size(); ++i) {
            if (items.get(i).m_41720_() != targetItem) continue;
            return i;
        }
        return -1;
    }

    @Unique
    private boolean vminus$containsItem(@NotNull Collection<ItemStack> items, Item item) {
        for (ItemStack stack : items) {
            if (stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull VisionType<?> vMinus$getVisionType() {
        return VisionTypes.TAB;
    }

    @Override
    public void vMinus$setVisionId(ResourceLocation id) {
        this.vMinus$visionId = id;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVisionId() {
        return this.vMinus$visionId;
    }
}

