/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.client.sounds;

import com.mojang.blaze3d.audio.SoundBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.audio.OggOpusAudioStream;
import net.lixir.vminus.mixins.client.sounds.SoundBufferLibraryAccessor;
import net.minecraft.Util;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.LoopingAudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundBufferLibrary.class})
public class SoundBufferLibraryMixin {
    @Shadow
    @Final
    private ResourceProvider f_120189_;
    @Shadow
    @Final
    private Map<ResourceLocation, CompletableFuture<SoundBuffer>> f_120190_;
    @Unique
    private final SoundBufferLibrary vminus$soundBufferLibrary = (SoundBufferLibrary)this;

    @Inject(method={"getStream"}, at={@At(value="RETURN")}, cancellable=true)
    private void detour$injectOpusSupport(ResourceLocation location, boolean looping, CallbackInfoReturnable<CompletableFuture<AudioStream>> cir) {
        if (location.m_135815_().endsWith(".opus")) {
            ResourceProvider provider = ((SoundBufferLibraryAccessor)this.vminus$soundBufferLibrary).detour$getResourceProvider();
            cir.setReturnValue(CompletableFuture.supplyAsync(() -> {
                try {
                    InputStream stream = provider.m_215595_(location);
                    if (looping) {
                        return new LoopingAudioStream(OggOpusAudioStream::new, stream);
                    }
                    return new OggOpusAudioStream(stream);
                }
                catch (IOException e) {
                    throw new CompletionException("Failed to load Opus stream: " + location, e);
                }
            }, Util.m_183991_()));
        }
    }

    @Inject(method={"getCompleteBuffer"}, at={@At(value="RETURN")}, cancellable=true)
    public void supportOpus(ResourceLocation location, CallbackInfoReturnable<CompletableFuture<SoundBuffer>> cir) {
        if (location.m_135815_().endsWith(".opus")) {
            this.f_120190_.remove(location);
            cir.setReturnValue((Object)this.f_120190_.computeIfAbsent(location, loc -> CompletableFuture.supplyAsync(() -> {
                try (InputStream input = this.f_120189_.m_215595_(loc);){
                    OggOpusAudioStream stream = new OggOpusAudioStream(input);
                    try {
                        ByteBuffer buffer = stream.readAll();
                        SoundBuffer soundBuffer = new SoundBuffer(buffer, stream.m_6206_());
                        stream.close();
                        return soundBuffer;
                    }
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    VMinus.LOGGER.error("IO error while loading Opus stream {}: {}", loc, (Object)e.getMessage(), (Object)e);
                    throw new CompletionException(e);
                }
                catch (Throwable t) {
                    VMinus.LOGGER.error("Unexpected error while loading Opus stream {}: {}", loc, (Object)t.getMessage(), (Object)t);
                    throw new CompletionException(t);
                }
            }, Util.m_183991_())));
        }
    }
}

