/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events.entity;

import java.util.List;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.util.BaseAttribute;
import net.lixir.vminus.vision.util.ItemReplacement;
import net.lixir.vminus.vision.util.VisionUtils;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class EntityJoinLevelEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEntityJoin(@NotNull EntityJoinLevelEvent event) {
        Boolean ban;
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            List<BaseAttribute> baseAttributeValues = Vision.get((Entity)livingEntity).getValues(VisionProperties.Entities.BASE_ATTRIBUTE, new VisionContext((Entity)livingEntity));
            for (BaseAttribute baseAttribute : baseAttributeValues) {
                Attribute attribute = baseAttribute.attribute();
                Double value = baseAttribute.value();
                AttributeInstance attributeInstance = livingEntity.m_21051_(attribute);
                if (attributeInstance == null) continue;
                attributeInstance.m_22100_(value.doubleValue());
            }
        }
        if (Boolean.TRUE.equals(ban = Vision.getValue(entity, VisionProperties.Entities.BAN))) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            } else if (event.hasResult()) {
                event.setResult(Event.Result.DENY);
            }
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack stack = itemEntity.m_32055_();
            Item item = stack.m_41720_();
            VisionDuck visionDuck = (VisionDuck)item;
            VisionContext visionContext = new VisionContext.Builder().pass(stack).pass(entity).build();
            ItemReplacement itemReplacement = VisionUtils.getOverrideValue(visionDuck, VisionProperties.Items.REPLACE, visionContext);
            Boolean itemBan = VisionUtils.getOverrideValue(visionDuck, VisionProperties.Items.BAN, visionContext);
            if (itemReplacement != null) {
                ItemStack replacementStack = itemReplacement.itemStack();
                if (replacementStack != null && !replacementStack.m_41619_()) {
                    replacementStack.m_41764_(stack.m_41613_());
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    } else if (event.hasResult()) {
                        event.setResult(Event.Result.DENY);
                    }
                    Level world = entity.m_9236_();
                    ItemEntity newItemEntity = new ItemEntity(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), replacementStack);
                    newItemEntity.m_20256_(entity.m_20184_());
                    world.m_7967_((Entity)newItemEntity);
                }
            } else if (itemBan != null && itemBan.booleanValue()) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                } else if (event.hasResult()) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }
}

