/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events.client;

import net.lixir.vminus.registry.TintType;
import net.lixir.vminus.registry.VRegistry;
import net.lixir.vminus.registry.entry.BlockEntry;
import net.lixir.vminus.registry.entry.ItemEntry;
import net.lixir.vminus.registry.entry.accessor.BlockEntryAccessor;
import net.lixir.vminus.registry.entry.accessor.ItemEntryAccessor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterColorEventHandler {
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        for (VRegistry vRegistry : VRegistry.getRegistries()) {
            for (Item item : vRegistry.getItems()) {
                TintType tintType;
                ItemEntryAccessor accessor = (ItemEntryAccessor)item;
                ItemEntry itemEntry = accessor.vminus$getEntry();
                if (itemEntry == null || (tintType = itemEntry.getTint()) == TintType.UNSET || tintType == TintType.NONE) continue;
                switch (tintType) {
                    case FOLIAGE: {
                        event.register((stack, tintIndex) -> tintIndex == 0 ? FoliageColor.m_46113_() : -1, new ItemLike[]{item});
                        break;
                    }
                    case GRASS: {
                        event.register((stack, tintIndex) -> tintIndex == 0 ? GrassColor.m_276205_() : -1, new ItemLike[]{item});
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        for (VRegistry vRegistry : VRegistry.getRegistries()) {
            for (Block block : vRegistry.getBlocks()) {
                TintType tintType;
                BlockEntryAccessor accessor = (BlockEntryAccessor)block;
                BlockEntry blockEntry = accessor.vminus$getEntry();
                if (blockEntry == null || (tintType = blockEntry.getTintType()) == TintType.UNSET || tintType == TintType.NONE) continue;
                switch (tintType) {
                    case FOLIAGE: {
                        event.getBlockColors().m_92589_((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_(), new Block[]{block});
                        break;
                    }
                    case GRASS: {
                        event.getBlockColors().m_92589_((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_276205_(), new Block[]{block});
                    }
                }
            }
        }
    }
}

