/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.datagen.SoundDefinitionInfo;
import net.lixir.vminus.mixins.data.sounddefinition.SoundDefinitionAccessor;
import net.lixir.vminus.mixins.data.sounddefinition.SoundDefinitionSoundAccessor;
import net.lixir.vminus.mixins.data.sounddefinition.SoundDefinitionsProviderAccessor;
import net.lixir.vminus.registry.VRegistry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class VSoundDefinitionProvider
extends SoundDefinitionsProvider {
    protected final PackOutput output;
    protected final String modId;
    protected final ExistingFileHelper helper;

    public VSoundDefinitionProvider(PackOutput output, ExistingFileHelper helper, String modId) {
        super(output, modId, helper);
        this.output = output;
        this.modId = modId;
        this.helper = helper;
    }

    public String getModId() {
        return this.modId;
    }

    public void registerSounds() {
        for (SoundDefinitionInfo info : VRegistry.fromId(this.modId).getSoundDefinitionInfo()) {
            this.add(info.getSoundEvent(), this.generateSoundDefinition(info));
        }
    }

    protected SoundDefinition generateSoundDefinition(@NotNull SoundDefinitionInfo info) {
        SoundDefinition soundDefinition;
        String eventPath = ForgeRegistries.SOUND_EVENTS.getKey((Object)info.getSoundEvent()).m_135815_();
        String subtitle = info.getSubtitle() != null ? (info.getSubtitle().equals("default") ? "subtitles." + eventPath : info.getSubtitle()) : null;
        String soundPath = info.getPath();
        List<String> paths = info.getPaths();
        HashMap<CallSite, SoundDefinition.Sound> soundMap = new HashMap<CallSite, SoundDefinition.Sound>();
        if (paths != null && !paths.isEmpty()) {
            SoundDefinition.Sound[] sounds = new SoundDefinition.Sound[paths.size()];
            for (int i = 0; i < paths.size(); ++i) {
                sounds[i] = VSoundDefinitionProvider.sound((ResourceLocation)new ResourceLocation(this.modId, paths.get(i)));
            }
            soundDefinition = VSoundDefinitionProvider.definition().with(sounds);
        } else {
            int count = info.getCount();
            if (count == 1) {
                soundDefinition = VSoundDefinitionProvider.definition().with(VSoundDefinitionProvider.sound((ResourceLocation)new ResourceLocation(this.modId, soundPath)));
            } else {
                SoundDefinition.Sound[] sounds = new SoundDefinition.Sound[count];
                boolean isOpus = soundPath.endsWith(".opus");
                String basePath = isOpus ? soundPath.substring(0, soundPath.length() - 5) : soundPath;
                for (int i = 0; i < count; ++i) {
                    SoundDefinition.Sound s;
                    String suffix = String.valueOf(i + 1);
                    String fullPath = basePath + suffix;
                    String fullFilePath = fullPath + (isOpus ? ".opus" : "");
                    sounds[i] = s = VSoundDefinitionProvider.sound((ResourceLocation)new ResourceLocation(this.modId, fullFilePath));
                    soundMap.put((CallSite)((Object)fullPath), s);
                }
                if (info.getDefaultWeight() != 1) {
                    for (SoundDefinition.Sound sound : soundMap.values()) {
                        sound.weight(info.getDefaultWeight());
                    }
                }
                for (SoundDefinitionInfo.Weight weight : info.getWeights()) {
                    String suffix = weight.path();
                    String fullPath = basePath + suffix;
                    SoundDefinition.Sound sound = (SoundDefinition.Sound)soundMap.get(fullPath);
                    if (sound == null) continue;
                    sound.weight(weight.weight());
                }
                soundDefinition = VSoundDefinitionProvider.definition().with(sounds);
            }
        }
        if (subtitle != null) {
            soundDefinition.subtitle(subtitle);
        }
        return soundDefinition;
    }

    protected SoundDefinition multiVariantSound(String eventPath, String basePath, int variantCount) {
        return this.multiVariantSound(eventPath, "subtitles." + eventPath, basePath, variantCount);
    }

    protected SoundDefinition multiVariantSound(String eventPath, String subtitle, String basePath, int variantCount) {
        SoundDefinition.Sound[] sounds = new SoundDefinition.Sound[variantCount];
        for (int i = 0; i < variantCount; ++i) {
            sounds[i] = VSoundDefinitionProvider.sound((ResourceLocation)new ResourceLocation(this.modId, basePath + (i + 1)));
        }
        return VSoundDefinitionProvider.definition().with(sounds).subtitle(subtitle);
    }

    protected SoundDefinition singleSound(String eventPath, String subtitle, String soundPath) {
        return VSoundDefinitionProvider.definition().with(VSoundDefinitionProvider.sound((ResourceLocation)new ResourceLocation(this.modId, soundPath))).subtitle(subtitle);
    }

    protected SoundDefinition singleSound(String eventPath, String soundPath) {
        return VSoundDefinitionProvider.definition().with(VSoundDefinitionProvider.sound((ResourceLocation)new ResourceLocation(this.modId, soundPath))).subtitle("subtitles." + eventPath);
    }

    protected SoundDefinition singleSoundWithoutSubtitle(String eventPath, String soundPath) {
        return VSoundDefinitionProvider.definition().with(VSoundDefinitionProvider.sound((ResourceLocation)new ResourceLocation(this.modId, soundPath)));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        SoundDefinitionsProviderAccessor accessor = (SoundDefinitionsProviderAccessor)((Object)this);
        Map<String, SoundDefinition> sounds = accessor.getSoundList();
        sounds.clear();
        this.registerSounds();
        List<String> notValid = sounds.entrySet().stream().filter(it -> !this.customValidate((String)it.getKey(), (SoundDefinition)it.getValue())).map(Map.Entry::getKey).map(it -> this.modId + ":" + it).toList();
        if (!notValid.isEmpty()) {
            throw new IllegalStateException("Found invalid sound events: " + notValid);
        }
        if (!sounds.isEmpty()) {
            return accessor.invokeSave(cache, this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modId).resolve("sounds.json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private boolean customValidate(String name, SoundDefinition def) {
        SoundDefinitionAccessor accessor = (SoundDefinitionAccessor)def;
        return accessor.getSoundList().stream().allMatch(it -> {
            SoundDefinitionSoundAccessor soundAccessor = (SoundDefinitionSoundAccessor)it;
            return this.customValidateSound(name, soundAccessor.getName());
        });
    }

    private boolean customValidateSound(String soundName, ResourceLocation name) {
        boolean valid;
        String namespace = name.m_135827_();
        String path = name.m_135815_();
        if (path.endsWith(".opus")) {
            path = path.substring(0, path.indexOf(".opus"));
        }
        name = new ResourceLocation(namespace, path);
        boolean oggExists = this.helper.exists(name, PackType.CLIENT_RESOURCES, ".ogg", "sounds");
        boolean opusExists = this.helper.exists(name, PackType.CLIENT_RESOURCES, ".opus", "sounds");
        boolean bl = valid = oggExists || opusExists;
        if (!valid) {
            String oggPath = namespace + ":sounds/" + path + ".ogg";
            String opusPath = namespace + ":sounds/" + path + ".opus";
            VMinus.LOGGER.warn("Unable to find corresponding OGG or OPUS file '{}' or '{}' for sound event '{}'", (Object)oggPath, (Object)opusPath, (Object)soundName);
        }
        return valid;
    }
}

