/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.block;

import net.lixir.vminus.block.StainedGlassSlabBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public final class StainedGlassStairsBlock
extends StairBlock
implements BeaconBeamBlock {
    private final DyeColor color;

    public StainedGlassStairsBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(() -> ((Block)Blocks.f_50058_).m_49966_(), settings);
        this.color = color;
    }

    public boolean m_6104_(@NotNull BlockState state, BlockState stateFrom, @NotNull Direction direction) {
        Block blockFrom = stateFrom.m_60734_();
        if (blockFrom instanceof StainedGlassBlock && ((StainedGlassBlock)blockFrom).m_7988_() == this.color) {
            return true;
        }
        if (blockFrom instanceof StainedGlassSlabBlock && ((StainedGlassSlabBlock)blockFrom).m_7988_() == this.color && this.isInvisibleToGlassSlab(state, stateFrom, direction)) {
            return true;
        }
        if (blockFrom == this && this.isInvisibleToGlassStairs(state, stateFrom, direction)) {
            return true;
        }
        return super.m_6104_(state, stateFrom, direction);
    }

    private boolean isInvisibleToGlassSlab(BlockState state, BlockState stateFrom, Direction direction) {
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        SlabType typeFrom = (SlabType)stateFrom.m_61143_((Property)SlabBlock.f_56353_);
        if (direction == Direction.UP && typeFrom != SlabType.TOP) {
            return true;
        }
        if (direction == Direction.DOWN && typeFrom != SlabType.BOTTOM) {
            return true;
        }
        if (typeFrom == SlabType.DOUBLE) {
            return true;
        }
        if (direction == facing.m_122424_()) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            if (typeFrom == SlabType.TOP && half == Half.TOP) {
                return true;
            }
        }
        if (direction == facing.m_122427_() && shape == StairsShape.OUTER_LEFT) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            if (typeFrom == SlabType.TOP && half == Half.TOP) {
                return true;
            }
        }
        if (direction == facing.m_122428_() && shape == StairsShape.OUTER_RIGHT) {
            if (typeFrom == SlabType.BOTTOM && half == Half.BOTTOM) {
                return true;
            }
            return typeFrom == SlabType.TOP && half == Half.TOP;
        }
        return false;
    }

    private boolean isInvisibleToGlassStairs(BlockState state, BlockState stateFrom, Direction direction) {
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        Half halfFrom = (Half)stateFrom.m_61143_((Property)StairBlock.f_56842_);
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        Direction facingFrom = (Direction)stateFrom.m_61143_((Property)StairBlock.f_56841_);
        StairsShape shape = (StairsShape)state.m_61143_((Property)StairBlock.f_56843_);
        StairsShape shapeFrom = (StairsShape)stateFrom.m_61143_((Property)StairBlock.f_56843_);
        if (direction == Direction.UP) {
            if (halfFrom == Half.BOTTOM) {
                return true;
            }
            if (half != halfFrom) {
                if (facing == facingFrom && shape == shapeFrom) {
                    return true;
                }
                switch (shape) {
                    case STRAIGHT: {
                        if (shapeFrom == StairsShape.INNER_LEFT && (facingFrom == facing || facingFrom == facing.m_122427_())) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                        return true;
                    }
                    case INNER_LEFT: {
                        if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing.m_122428_()) break;
                        return true;
                    }
                    case INNER_RIGHT: {
                        if (shapeFrom != StairsShape.INNER_LEFT || facingFrom != facing.m_122427_()) break;
                        return true;
                    }
                    case OUTER_LEFT: {
                        if (shapeFrom == StairsShape.OUTER_RIGHT && facingFrom == facing.m_122428_()) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                        return true;
                    }
                    case OUTER_RIGHT: {
                        if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom == facing.m_122427_()) {
                            return true;
                        }
                        if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122427_()) break;
                        return true;
                    }
                }
            }
        }
        if (direction == Direction.DOWN) {
            if (halfFrom == Half.TOP) {
                return true;
            }
            switch (shape) {
                case STRAIGHT: {
                    if (shapeFrom == StairsShape.INNER_LEFT && (facingFrom == facing || facingFrom == facing.m_122427_())) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                    return true;
                }
                case INNER_LEFT: {
                    if (shapeFrom != StairsShape.INNER_RIGHT || facingFrom != facing.m_122428_()) break;
                    return true;
                }
                case INNER_RIGHT: {
                    if (shapeFrom != StairsShape.INNER_LEFT || facingFrom != facing.m_122427_()) break;
                    return true;
                }
                case OUTER_LEFT: {
                    if (shapeFrom == StairsShape.OUTER_RIGHT && facingFrom == facing.m_122428_()) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122428_()) break;
                    return true;
                }
                case OUTER_RIGHT: {
                    if (shapeFrom == StairsShape.OUTER_LEFT && facingFrom == facing.m_122427_()) {
                        return true;
                    }
                    if (shapeFrom != StairsShape.STRAIGHT || facingFrom != facing && facingFrom != facing.m_122427_()) break;
                    return true;
                }
            }
        }
        if (facingFrom == direction.m_122424_() && shapeFrom != StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
            return true;
        }
        if (facingFrom.m_122428_() == direction && shapeFrom == StairsShape.INNER_RIGHT) {
            return true;
        }
        if (facingFrom.m_122427_() == direction && shapeFrom == StairsShape.INNER_LEFT) {
            return true;
        }
        if (direction == facing && half == halfFrom) {
            if (facingFrom == facing.m_122428_() && shape == StairsShape.OUTER_LEFT && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.m_122427_() && shape == StairsShape.OUTER_RIGHT && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
        }
        if (direction == facing.m_122424_() && half == halfFrom) {
            if (facingFrom == facing.m_122428_() && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
            if (facingFrom == facing.m_122427_() && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.m_122424_()) {
                return true;
            }
        }
        if (direction == facing.m_122428_() && half == halfFrom) {
            if (facingFrom == direction && shape != StairsShape.INNER_LEFT && shapeFrom == StairsShape.INNER_RIGHT) {
                return true;
            }
            if (facingFrom == facing && shapeFrom != StairsShape.OUTER_LEFT) {
                return true;
            }
            if (facingFrom == facing.m_122427_() && shapeFrom == StairsShape.OUTER_LEFT && shape != StairsShape.INNER_LEFT) {
                return true;
            }
            if (facingFrom == facing.m_122424_() && shape == StairsShape.OUTER_RIGHT) {
                return true;
            }
        }
        if (direction == facing.m_122427_() && half == halfFrom) {
            if (facingFrom == direction && shape != StairsShape.INNER_RIGHT && shapeFrom == StairsShape.INNER_LEFT) {
                return true;
            }
            if (facingFrom == facing && shapeFrom != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (facingFrom == facing.m_122428_() && shapeFrom == StairsShape.OUTER_RIGHT && shape != StairsShape.INNER_RIGHT) {
                return true;
            }
            return facingFrom == facing.m_122424_() && shape == StairsShape.OUTER_LEFT;
        }
        return false;
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public DyeColor m_7988_() {
        return this.color;
    }
}

