/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.majruszlibrary.data.IReader;
import java.util.UUID;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

class ReaderUUID
implements IReader<UUID> {
    ReaderUUID() {
    }

    @Override
    public JsonElement writeJson(UUID value) {
        return new JsonPrimitive(value.toString());
    }

    @Override
    public UUID readJson(JsonElement json) {
        return UUID.fromString(json.getAsString());
    }

    @Override
    public void writeBuffer(FriendlyByteBuf buffer, UUID value) {
        buffer.writeLong(value.getMostSignificantBits());
        buffer.writeLong(value.getLeastSignificantBits());
    }

    @Override
    public UUID readBuffer(FriendlyByteBuf buffer) {
        return new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public Tag writeTag(UUID value) {
        return NbtUtils.m_129226_((UUID)value);
    }

    @Override
    public UUID readTag(Tag tag) {
        return NbtUtils.m_129233_((Tag)tag);
    }
}

