/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api;

import com.obscuria.obscureapi.api.common.classes.ObscureClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;

public final class ClassManager {
    private static final HashMap<ResourceLocation, ObscureClass> CLASSES = new HashMap();
    public static final ObscureClass BLANK = new ObscureClass("obscure_api", "blank");

    @Nonnull
    public static ObscureClass register(String modID, String name) {
        ObscureClass obscureClass = new ObscureClass(modID, name);
        CLASSES.put(obscureClass.getRegistry(), obscureClass);
        return obscureClass;
    }

    public static boolean isPresent(ResourceLocation key) {
        return CLASSES.containsKey(key);
    }

    public static ObscureClass get(ResourceLocation key) {
        return CLASSES.getOrDefault(key, BLANK);
    }

    @Nonnull
    @Contract(value=" -> new")
    public static List<ObscureClass> getAll() {
        return new ArrayList<ObscureClass>(CLASSES.values());
    }
}

