/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.CurvedTrackSelectionPacket;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import java.util.List;
import java.util.function.BiConsumer;
import net.createmod.catnip.data.Couple;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;

public class TrackTargetingBlockItem
extends BlockItem {
    private EdgePointType<?> type;

    public static <T extends Block> NonNullBiFunction<? super T, Item.Properties, TrackTargetingBlockItem> ofType(EdgePointType<?> type) {
        return (b, p) -> new TrackTargetingBlockItem((Block)b, (Item.Properties)p, type);
    }

    public TrackTargetingBlockItem(Block pBlock, Item.Properties pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties);
        this.type = type;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_() && stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)CreateLang.translateDirect("track_target.clear", new Object[0]), true);
            stack.m_41751_(null);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 0.5f);
            return InteractionResult.SUCCESS;
        }
        Block block = state.m_60734_();
        if (block instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)block;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Vec3 lookAngle = player.m_20154_();
            boolean front = track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
            EdgePointType<?> type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            TrackTargetingBlockItem.withGraphLocation(level, pos, front, null, type, (overlap, location) -> result.setValue((Object)overlap));
            if (((OverlapResult)((Object)result.getValue())).feedback != null) {
                player.m_5661_((Component)CreateLang.translateDirect(((OverlapResult)((Object)result.getValue())).feedback, new Object[0]).m_130940_(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            stackTag.m_128379_("SelectedDirection", front);
            stackTag.m_128473_("Bezier");
            player.m_5661_((Component)CreateLang.translateDirect("track_target.set", new Object[0]), true);
            stack.m_41751_(stackTag);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41782_()) {
            player.m_5661_((Component)CreateLang.translateDirect("track_target.missing", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        CompoundTag tag = stack.m_41783_();
        CompoundTag teTag = new CompoundTag();
        teTag.m_128379_("TargetDirection", tag.m_128471_("SelectedDirection"));
        BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("SelectedPos"));
        BlockPos placedPos = pos.m_5484_(pContext.m_43719_(), state.m_247087_() ? 0 : 1);
        boolean bezier = tag.m_128441_("Bezier");
        if (!selectedPos.m_123314_((Vec3i)placedPos, bezier ? (double)((Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() + 16) : 16.0)) {
            player.m_5661_((Component)CreateLang.translateDirect("track_target.too_far", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (bezier) {
            teTag.m_128365_("Bezier", (Tag)tag.m_128469_("Bezier"));
        }
        teTag.m_128365_("TargetTrack", (Tag)NbtUtils.m_129224_((BlockPos)selectedPos.m_121996_((Vec3i)placedPos)));
        tag.m_128365_("BlockEntityTag", (Tag)teTag);
        InteractionResult useOn = super.m_6225_(pContext);
        if (level.f_46443_ || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        ItemStack itemInHand = player.m_21120_(pContext.m_43724_());
        if (!itemInHand.m_41619_()) {
            itemInHand.m_41751_(null);
        }
        player.m_5661_((Component)CreateLang.translateDirect("track_target.success", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
        if (this.type == EdgePointType.SIGNAL) {
            AllAdvancements.SIGNAL.awardTo(player);
        }
        return useOn;
    }

    public EdgePointType<?> getType(ItemStack stack) {
        return this.type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        TrackBlockEntity be = selection.blockEntity();
        BezierTrackPointLocation loc = selection.loc();
        boolean front = player.m_20154_().m_82526_(selection.direction()) < 0.0;
        AllPackets.getChannel().sendToServer((Object)new CurvedTrackSelectionPacket(be.m_58899_(), loc.curveTarget(), loc.segment(), front, player.m_150109_().f_35977_));
        return true;
    }

    public static void withGraphLocation(Level level, BlockPos pos, boolean front, BezierTrackPointLocation targetBezier, EdgePointType<?> type, BiConsumer<OverlapResult, TrackGraphLocation> callback) {
        TrackGraphLocation location;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        List<Vec3> trackAxes = track.getTrackAxes((BlockGetter)level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(OverlapResult.JUNCTION, null);
            return;
        }
        Direction.AxisDirection targetDirection = front ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        TrackGraphLocation trackGraphLocation = location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, targetDirection, targetBezier) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.get(0));
        if (location == null) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }
        Couple nodes = location.edge.map(location.graph::locateNode);
        TrackEdge edge = location.graph.getConnection((Couple<TrackNode>)nodes);
        if (edge == null) {
            return;
        }
        EdgeData edgeData = edge.getEdgeData();
        double edgePosition = location.position;
        for (TrackEdgePoint edgePoint : edgeData.getPoints()) {
            double otherEdgePosition = edgePoint.getLocationOn(edge);
            double distance = Math.abs(edgePosition - otherEdgePosition);
            if (distance > 0.75 || edgePoint.canCoexistWith(type, front) && distance < 0.25) continue;
            callback.accept(OverlapResult.OCCUPIED, location);
            return;
        }
        callback.accept(OverlapResult.VALID, location);
    }

    public static enum OverlapResult {
        VALID,
        OCCUPIED("track_target.occupied"),
        JUNCTION("track_target.no_junctions"),
        NO_TRACK("track_target.invalid");

        public String feedback;

        private OverlapResult() {
        }

        private OverlapResult(String feedback) {
            this.feedback = feedback;
        }
    }
}

