/*
 * Decompiled with CFR 0.152.
 */
package com.aesefficio.interiors;

import com.aesefficio.interiors.content.registry.CITags;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public abstract class Utils {
    public static String getVersion(String modid) {
        return ModList.get().getModContainerById(modid).map(c -> c.getModInfo().getVersion().toString()).orElseThrow(() -> new IllegalStateException("Mod " + modid + " not found"));
    }

    public static boolean isDevEnv() {
        return !FMLLoader.isProduction();
    }

    public static String platformName() {
        return "Forge";
    }

    public static ResourceLocation id(String ns, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ns, (String)path);
    }

    public static DyeColor colorFromItem(ItemStack stack) {
        if (stack.m_41720_() instanceof DyeItem) {
            return ((DyeItem)stack.m_41720_()).m_41089_();
        }
        for (int x = 0; x < DyeColor.BLACK.m_41060_(); ++x) {
            DyeColor color = DyeColor.m_41053_((int)x);
            if (!stack.m_204117_(CITags.DYES.get(color))) continue;
            return color;
        }
        return null;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.ordinal() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

