/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import glitchcore.event.TickEvent;
import glitchcore.event.client.RenderGuiEvent;
import glitchcore.util.GuiUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;

public class TemperatureOverlayRenderer {
    private static final Random RANDOM = new Random();
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/icons.png");
    private static final ResourceLocation HYPERTHERMIA_OUTLINE_LOCATION = new ResourceLocation("toughasnails", "textures/misc/hyperthermia_outline.png");
    private static long updateCounter;
    private static long flashCounter;
    private static long arrowCounter;
    private static ArrowDirection arrowDirection;
    private static TemperatureLevel prevTemperatureLevel;

    public static void onBeginRenderFood(RenderGuiEvent.Pre event) {
        if (event.getType() != RenderGuiEvent.Type.FOOD) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && GuiUtils.shouldDrawSurvivalElements()) {
            GuiUtils.setupOverlayRenderState((boolean)true, (boolean)false);
            TemperatureOverlayRenderer.renderTemperature(event.getGuiGraphics(), event.getPartialTicks(), event.getScreenWidth(), event.getScreenHeight());
        }
    }

    public static void onBeginRenderFrostbite(RenderGuiEvent.Pre event) {
        if (event.getType() != RenderGuiEvent.Type.FROSTBITE) {
            return;
        }
        GuiUtils.setupOverlayRenderState((boolean)true, (boolean)false);
        Gui gui = event.getGui();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (TemperatureHelper.getTicksHyperthermic((Player)player) > 0) {
            gui.m_280155_(event.getGuiGraphics(), HYPERTHERMIA_OUTLINE_LOCATION, TemperatureHelper.getPercentHyperthermic((Player)player));
        }
    }

    public static void onClientTick(TickEvent.Client event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.getPhase() == TickEvent.Phase.END && !minecraft.m_91104_()) {
            ++updateCounter;
        }
    }

    public static void renderTemperature(GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!ModConfig.temperature.enableTemperature) {
            return;
        }
        LocalPlayer player = minecraft.f_91074_;
        TemperatureLevel temperature = TemperatureHelper.getTemperatureForPlayer((Player)player);
        RANDOM.setSeed(updateCounter * 312871L);
        if (minecraft.f_91072_.m_105295_().m_46409_()) {
            TemperatureOverlayRenderer.drawTemperature(guiGraphics, width, height, temperature);
        }
    }

    private static void drawTemperature(GuiGraphics gui, int width, int height, TemperatureLevel temperature) {
        int left = width / 2 - 8 + ModConfig.client.temperatureLeftOffset;
        int top = height - 52 + ModConfig.client.temperatureTopOffset;
        if (prevTemperatureLevel == null) {
            prevTemperatureLevel = temperature;
        }
        if (updateCounter > arrowCounter) {
            arrowDirection = null;
        }
        if (prevTemperatureLevel != temperature) {
            flashCounter = updateCounter + 3L;
            arrowCounter = updateCounter + 15L;
            if (temperature.compareTo(prevTemperatureLevel) > 0) {
                arrowDirection = ArrowDirection.UP;
            } else if (temperature.compareTo(prevTemperatureLevel) < 0) {
                arrowDirection = ArrowDirection.DOWN;
            }
        }
        prevTemperatureLevel = temperature;
        if ((temperature == TemperatureLevel.ICY || temperature == TemperatureLevel.HOT) && updateCounter % 1L == 0L) {
            top += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(3.0, 1.0));
            left += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(1.5, 1.0));
        }
        int iconIndex = temperature.ordinal() * 16;
        int v = 0;
        if (flashCounter > updateCounter) {
            v += 16;
        }
        gui.m_280218_(OVERLAY, left, top, iconIndex, v, 16, 16);
        if (arrowDirection != null) {
            gui.m_280218_(OVERLAY, left, top, arrowDirection.getU(15 - (int)(arrowCounter - updateCounter)), arrowDirection.getV(), 16, 16);
        }
    }

    private static enum ArrowDirection {
        UP(224),
        DOWN(240);

        private final int v;

        private ArrowDirection(int v) {
            this.v = v;
        }

        public int getU(int frame) {
            return frame * 16;
        }

        public int getV() {
            return this.v;
        }
    }
}

