/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.feature.config.LollipopFeatureConfiguration;
import com.github.alexmodguy.alexscaves.server.level.structure.processor.LollipopProcessor;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class LollipopFeature
extends Feature<LollipopFeatureConfiguration> {
    public LollipopFeature(Codec<LollipopFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<LollipopFeatureConfiguration> context) {
        BlockPos genAt;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!level.m_8055_(genAt = context.m_159777_()).m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get())) {
            return false;
        }
        boolean big = randomsource.m_188501_() < ((LollipopFeatureConfiguration)context.m_159778_()).bigChance;
        genAt = genAt.m_7494_();
        int poleHeight = 3 + randomsource.m_188503_(3);
        if (big) {
            poleHeight += 4 + randomsource.m_188503_(2);
        }
        if (this.hasClearance(level, genAt, poleHeight + (big ? 10 : 6))) {
            for (int i = 0; i < poleHeight; ++i) {
                level.m_7731_(genAt.m_6630_(i), ((Block)ACBlockRegistry.STRIPPED_CANDY_CANE_BLOCK.get()).m_49966_(), 4);
            }
            BlockPos structurePos = genAt.m_6630_(poleHeight);
            Rotation rotation = Rotation.m_221990_((RandomSource)randomsource);
            ResourceLocation structureLocation = big ? ((LollipopFeatureConfiguration)context.m_159778_()).bigLollipopTopStructures.get(randomsource.m_188503_(((LollipopFeatureConfiguration)context.m_159778_()).bigLollipopTopStructures.size())) : ((LollipopFeatureConfiguration)context.m_159778_()).smallLollipopTopStructures.get(randomsource.m_188503_(((LollipopFeatureConfiguration)context.m_159778_()).smallLollipopTopStructures.size()));
            StructureTemplateManager structuretemplatemanager = level.m_6018_().m_7654_().m_236738_();
            StructureTemplate structuretemplate = structuretemplatemanager.m_230359_(structureLocation);
            StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().m_74379_(rotation).m_230324_(randomsource).m_74383_((StructureProcessor)new LollipopProcessor(randomsource));
            Vec3i rotatedSize = structuretemplate.m_163808_(rotation);
            BlockPos blockpos1 = structurePos.m_7918_(-Math.round((float)rotatedSize.m_123341_() / 2.0f - 1.0f), 0, (int)(-Math.ceil((float)rotatedSize.m_123343_() / 2.0f - 1.0f)));
            BlockPos blockpos2 = structuretemplate.m_74583_(blockpos1, Mirror.NONE, rotation);
            structuretemplate.m_230328_((ServerLevelAccessor)level, blockpos2, blockpos2, structureplacesettings, randomsource, 4);
            return true;
        }
        return false;
    }

    private boolean hasClearance(WorldGenLevel level, BlockPos pos, int height) {
        for (int i = 1; i <= height; ++i) {
            if (level.m_8055_(pos.m_6630_(i)).m_247087_()) continue;
            return false;
        }
        return true;
    }
}

