/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MagneticWeaponEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class TeletorEntity
extends Monster {
    private static ImmutableList<Item> HELD_ITEM_POSSIBILITIES = null;
    private static final EntityDataAccessor<Optional<UUID>> WEAPON_UUID = SynchedEntityData.m_135353_(TeletorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> WEAPON_ID = SynchedEntityData.m_135353_(TeletorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float prevControlProgress = 0.0f;
    private float controlProgress = 0.0f;
    private Vec3[][] trailPositions = new Vec3[64][2];
    private int trailPointer = -1;
    private int floatingTicks = 0;

    public TeletorEntity(EntityType<? extends Monster> teletor, Level level) {
        super(teletor, level);
        this.f_21342_ = new MoveController();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WEAPON_UUID, Optional.empty());
        this.f_19804_.m_135372_(WEAPON_ID, (Object)-1);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    protected PathNavigation m_6037_(Level p_27815_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_27815_){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return this.m_9236_().m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Nullable
    public UUID getWeaponUUID() {
        return ((Optional)this.f_19804_.m_135370_(WEAPON_UUID)).orElse(null);
    }

    public void setWeaponUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(WEAPON_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getWeapon() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getWeaponUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(WEAPON_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("WeaponUUID")) {
            this.setWeaponUUID(compound.m_128342_("WeaponUUID"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getWeaponUUID() != null) {
            compound.m_128362_("WeaponUUID", this.getWeaponUUID());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 18.0);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.55f * dimensions.f_20378_;
    }

    public boolean areLegsCrossed(float limbSwing) {
        return this.m_6084_() && limbSwing <= 0.35f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevControlProgress = this.controlProgress;
        Entity weapon = this.getWeapon();
        if (weapon instanceof MagneticWeaponEntity) {
            boolean control;
            MagneticWeaponEntity magneticWeapon = (MagneticWeaponEntity)weapon;
            this.f_19804_.m_135381_(WEAPON_ID, (Object)magneticWeapon.m_19879_());
            magneticWeapon.setControllerUUID(this.m_20148_());
            Entity e = magneticWeapon.getTarget();
            boolean bl = control = e != null && e.m_6084_();
            if (control && this.controlProgress < 5.0f) {
                this.controlProgress += 1.0f;
            }
            if (!control && this.controlProgress > 0.0f) {
                this.controlProgress -= 1.0f;
            }
        }
        if (this.m_9236_().f_46443_) {
            this.tickVisual();
        }
        if (this.floatingTicks-- <= 0) {
            this.floatingTicks = 30;
            this.m_216990_((SoundEvent)ACSoundRegistry.TELETOR_FLOAT.get());
        }
        this.m_20256_(this.m_20184_().m_82542_((double)0.98f, (double)0.98f, (double)0.98f));
    }

    public void tickVisual() {
        Vec3 blue = this.getHelmetPosition(0);
        Vec3 red = this.getHelmetPosition(1);
        if (this.trailPointer == -1) {
            for (int i = 0; i < this.trailPositions.length; ++i) {
                this.trailPositions[i][0] = blue;
                this.trailPositions[i][1] = red;
            }
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer][0] = blue;
        this.trailPositions[this.trailPointer][1] = red;
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    public float getControlProgress(float partialTick) {
        return (this.prevControlProgress + (this.controlProgress - this.prevControlProgress) * partialTick) * 0.2f;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public Vec3 getTrailPosition(int pointer, int side, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j][side];
        Vec3 d1 = this.trailPositions[i][side].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        MagneticWeaponEntity magneticWeapon = (MagneticWeaponEntity)((EntityType)ACEntityRegistry.MAGNETIC_WEAPON.get()).m_20615_(this.m_9236_());
        ItemStack stack = this.createItemStack(this.m_9236_().m_213780_());
        float f = difficultyIn.m_19057_();
        if (this.m_9236_().m_213780_().m_188501_() < 0.25f * (f + 0.5f)) {
            stack = EnchantmentHelper.m_220292_((RandomSource)this.m_9236_().m_213780_(), (ItemStack)stack, (int)((int)(5.0f + f * (float)this.m_9236_().m_213780_().m_188503_(18))), (boolean)false);
        }
        magneticWeapon.setItemStack(stack);
        magneticWeapon.m_146884_(this.getWeaponPosition());
        magneticWeapon.setControllerUUID(this.m_20148_());
        this.setWeaponUUID(magneticWeapon.m_20148_());
        this.m_9236_().m_7967_((Entity)magneticWeapon);
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public ItemStack createItemStack(RandomSource random) {
        if (HELD_ITEM_POSSIBILITIES == null || HELD_ITEM_POSSIBILITIES.isEmpty()) {
            HELD_ITEM_POSSIBILITIES = (ImmutableList)ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(ACTagRegistry.TELETOR_SPAWNS_WITH)).collect(ImmutableList.toImmutableList());
        }
        if (HELD_ITEM_POSSIBILITIES.size() <= 0 || random.m_188501_() < 0.3f) {
            return new ItemStack((ItemLike)Items.f_42383_);
        }
        if (HELD_ITEM_POSSIBILITIES.size() == 1) {
            return new ItemStack((ItemLike)HELD_ITEM_POSSIBILITIES.get(0));
        }
        return new ItemStack((ItemLike)HELD_ITEM_POSSIBILITIES.get(random.m_188503_(HELD_ITEM_POSSIBILITIES.size())));
    }

    public Vec3 getWeaponPosition() {
        return this.m_146892_().m_82520_(0.0, (double)1.4f - Math.sin((float)this.f_19797_ * 0.1f) * (double)0.2f, 0.0);
    }

    public Vec3 getHelmetPosition(int offsetFlag) {
        Vec3 helmet = new Vec3(offsetFlag == 0 ? (double)-0.65f : (double)0.65f, (double)1.1f, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
        return this.m_146892_().m_82549_(helmet);
    }

    protected void m_5907_() {
        super.m_5907_();
        Entity weapon = this.getWeapon();
        if (weapon instanceof MagneticWeaponEntity) {
            MagneticWeaponEntity magneticWeapon = (MagneticWeaponEntity)weapon;
            ItemStack itemstack = magneticWeapon.getItemStack();
            float f = this.m_21519_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack) && this.f_19796_.m_188501_() < f) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(itemstack.m_41776_() - 3, 1))));
                }
                this.m_19983_(itemstack);
            }
            magneticWeapon.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != ACEffectRegistry.MAGNETIZING.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.TELETOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.TELETOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.TELETOR_DEATH.get();
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController() {
            super((Mob)TeletorEntity.this);
            this.parentEntity = TeletorEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                LivingEntity attackTarget = this.parentEntity.m_5448_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.025 / d0);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d1));
                if (d0 < width * (double)0.3f) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width && attackTarget == null) {
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f);
                    if (TeletorEntity.this.m_5448_() != null) {
                        this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                    }
                }
            }
        }
    }

    private class MeleeGoal
    extends Goal {
        private int executionTime = 0;
        private BlockPos strafeOrigin = null;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = TeletorEntity.this.m_5448_();
            return target != null && target.m_6084_() && TeletorEntity.this.getWeapon() != null;
        }

        public void m_8056_() {
            this.executionTime = 0;
            this.strafeOrigin = null;
        }

        public void m_8037_() {
            ++this.executionTime;
            LivingEntity target = TeletorEntity.this.m_5448_();
            double dist = TeletorEntity.this.m_20270_((Entity)target);
            if (dist < 2.0) {
                this.strafeOrigin = TeletorEntity.this.m_20183_().m_7918_(TeletorEntity.this.f_19796_.m_188503_(16) - 8, TeletorEntity.this.f_19796_.m_188503_(8), TeletorEntity.this.f_19796_.m_188503_(16) - 8);
            }
            if (dist < 16.0) {
                Vec3 lookDist = target.m_146892_().m_82546_(TeletorEntity.this.m_146892_());
                float targetXRot = (float)(-(Mth.m_14136_((double)lookDist.f_82480_, (double)lookDist.m_165924_()) * 57.2957763671875));
                float targetYRot = (float)(-Mth.m_14136_((double)lookDist.f_82479_, (double)lookDist.f_82481_) * 57.2957763671875);
                TeletorEntity.this.m_21573_().m_26573_();
                float f = (float)this.executionTime * 0.1f;
                Vec3 strafe = new Vec3(Math.sin(f) * 5.0, Math.cos(f) * 2.0, 0.0).m_82524_(-targetYRot * ((float)Math.PI / 180));
                if (this.strafeOrigin == null) {
                    this.strafeOrigin = TeletorEntity.this.m_20183_();
                }
                Vec3 moveTo = Vec3.m_82512_((Vec3i)this.strafeOrigin).m_82549_(strafe);
                TeletorEntity.this.m_21566_().m_6849_(moveTo.f_82479_, moveTo.f_82480_, moveTo.f_82481_, 1.0);
                TeletorEntity.this.m_146926_(targetXRot);
                TeletorEntity.this.m_146922_(targetYRot);
            } else {
                this.strafeOrigin = null;
                TeletorEntity.this.m_21573_().m_5624_((Entity)target, 1.0);
            }
        }
    }
}

