/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.item.MovingMetalBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MovingBlockData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractMovingBlockEntity
extends Entity {
    private static final EntityDataAccessor<CompoundTag> BLOCK_DATA_TAG = SynchedEntityData.m_135353_(AbstractMovingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private List<MovingBlockData> data;
    private VoxelShape shape = null;
    private int placementCooldown = 40;
    private static boolean destroyErrorMessage;

    public AbstractMovingBlockEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (BLOCK_DATA_TAG.equals(entityDataAccessor)) {
            this.data = this.buildDataFromTrackerTag();
            this.shape = this.getShape();
            this.m_20011_(this.m_142242_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_DATA_TAG, (Object)new CompoundTag());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.movesEntities() && this.m_20184_().m_82553_() > 0.0) {
            this.moveEntitiesOnTop();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_ && this.canBePlaced()) {
            if (this.placementCooldown > 0) {
                --this.placementCooldown;
            } else {
                BlockPos set;
                boolean clearance = true;
                BlockPos pos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_());
                for (MovingBlockData dataBlock : this.getData()) {
                    set = pos.m_121955_((Vec3i)dataBlock.getOffset());
                    BlockState at = this.m_9236_().m_8055_(set);
                    if (at.m_60795_()) continue;
                    if (at.m_247087_()) {
                        this.m_9236_().m_46961_(set, true);
                        continue;
                    }
                    clearance = false;
                }
                if (clearance) {
                    for (MovingBlockData dataBlock : this.getData()) {
                        BlockEntity blockentity;
                        set = pos.m_121955_((Vec3i)dataBlock.getOffset());
                        this.m_9236_().m_46597_(set, dataBlock.getState());
                        if (dataBlock.blockData == null || !dataBlock.getState().m_155947_() || (blockentity = this.m_9236_().m_7702_(set)) == null) continue;
                        CompoundTag compoundtag = blockentity.m_187482_();
                        for (String s : dataBlock.blockData.m_128431_()) {
                            compoundtag.m_128365_(s, dataBlock.blockData.m_128423_(s).m_6426_());
                        }
                        try {
                            blockentity.m_142466_(compoundtag);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        blockentity.m_6596_();
                    }
                    this.m_142687_(Entity.RemovalReason.KILLED);
                } else {
                    this.placementCooldown = 5 + this.f_19796_.m_188503_(10);
                }
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(0.98));
    }

    public boolean canBePlaced() {
        return true;
    }

    public abstract boolean movesEntities();

    public void moveEntitiesOnTop() {
        for (Entity entity2 : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.0, (double)0.01f, 0.0), EntitySelector.f_20408_.and(entity -> !entity.m_20365_((Entity)this)))) {
            double gravity;
            if (entity2.f_19794_ || entity2 instanceof MovingMetalBlockEntity) continue;
            double d = gravity = entity2.m_20068_() ? 0.0 : 0.08;
            if (entity2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                AttributeInstance attribute = living.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                gravity = attribute.m_22135_();
            }
            float f2 = 1.0f;
            entity2.m_6478_(MoverType.SHULKER, new Vec3((double)(f2 * (float)this.m_20184_().f_82479_), (double)(f2 * (float)this.m_20184_().f_82480_), (double)(f2 * (float)this.m_20184_().f_82481_)));
            if (!(this.m_20184_().f_82480_ >= 0.0)) continue;
            entity2.m_20256_(entity2.m_20184_().m_82520_(0.0, gravity, 0.0));
        }
    }

    protected void createBlockDropAt(BlockPos crushPos, BlockState state, CompoundTag blockData) {
        block4: {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LootParams.Builder lootparams$builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)crushPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
                try {
                    List drops = state.m_287290_(lootparams$builder);
                    for (ItemStack drop : drops) {
                        Block.m_49840_((Level)serverLevel, (BlockPos)crushPos, (ItemStack)drop);
                    }
                    state.m_222967_(serverLevel, crushPos, ItemStack.f_41583_, true);
                }
                catch (Exception e) {
                    if (destroyErrorMessage) break block4;
                    destroyErrorMessage = true;
                    AlexsCaves.LOGGER.warn("Stopped crash when trying to destroy fake block entity for {}", (Object)state.m_60734_());
                }
            }
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("BlockDataContainer", 10)) {
            this.setAllBlockData(compound.m_128469_("BlockDataContainer"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.getAllBlockData() != null) {
            compound.m_128365_("BlockDataContainer", (Tag)this.getAllBlockData());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private List<MovingBlockData> buildDataFromTrackerTag() {
        ArrayList<MovingBlockData> list = new ArrayList<MovingBlockData>();
        CompoundTag data = this.getAllBlockData();
        if (data.m_128441_("BlockData")) {
            ListTag listTag = data.m_128437_("BlockData", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag innerTag = listTag.m_128728_(i);
                list.add(new MovingBlockData(this.m_9236_(), innerTag));
            }
        }
        return list;
    }

    public void setPlacementCooldown(int cooldown) {
        this.placementCooldown = cooldown;
    }

    public CompoundTag getAllBlockData() {
        return (CompoundTag)this.f_19804_.m_135370_(BLOCK_DATA_TAG);
    }

    public void setAllBlockData(CompoundTag tag) {
        this.f_19804_.m_135381_(BLOCK_DATA_TAG, (Object)tag);
    }

    public List<MovingBlockData> getData() {
        if (this.data == null) {
            this.data = this.buildDataFromTrackerTag();
        }
        return this.data;
    }

    public VoxelShape getShape() {
        Vec3 leftMostCorner = new Vec3(this.m_20185_() - 0.5, this.m_20186_() - 0.5, this.m_20189_() - 0.5);
        if (this.data == null || this.data.isEmpty()) {
            VoxelShape building = Shapes.m_166049_((double)leftMostCorner.f_82479_, (double)leftMostCorner.f_82480_, (double)leftMostCorner.f_82481_, (double)(leftMostCorner.f_82479_ + 1.0), (double)(leftMostCorner.f_82480_ + 1.0), (double)(leftMostCorner.f_82481_ + 1.0));
            return building;
        }
        VoxelShape building = Shapes.m_166049_((double)leftMostCorner.f_82479_, (double)leftMostCorner.f_82480_, (double)leftMostCorner.f_82481_, (double)(leftMostCorner.f_82479_ + 1.0), (double)(leftMostCorner.f_82480_ + 1.0), (double)(leftMostCorner.f_82481_ + 1.0));
        for (MovingBlockData data : this.getData()) {
            building = Shapes.m_83113_((VoxelShape)building, (VoxelShape)data.getShape().m_83216_(leftMostCorner.f_82479_ + (double)data.getOffset().m_123341_(), leftMostCorner.f_82480_ + (double)data.getOffset().m_123342_(), leftMostCorner.f_82481_ + (double)data.getOffset().m_123343_()), (BooleanOp)BooleanOp.f_82695_);
        }
        return building;
    }

    protected AABB m_142242_() {
        List aabbs = this.getShape().m_83299_();
        AABB minMax = new AABB(this.m_20185_() - 0.5, this.m_20186_() - 0.5, this.m_20189_() - 0.5, this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5);
        for (AABB aabb : aabbs) {
            minMax = minMax.m_82367_(aabb);
        }
        return minMax;
    }

    public Vec3 m_7371_(float f) {
        return this.m_20318_(f);
    }

    public static CompoundTag createTagFromData(List<MovingBlockData> blocks) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (MovingBlockData data : blocks) {
            listTag.add((Object)data.toTag());
        }
        tag.m_128365_("BlockData", (Tag)listTag);
        return tag;
    }

    public boolean m_5829_() {
        return false;
    }
}

